/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.db;

import com.foilen.smalltools.hash.HashMd5sum;
import com.foilen.smalltools.reflection.ReflectionTools;
import com.foilen.smalltools.streamwrapper.RenamingOnCloseOutputStreamWrapper;
import com.foilen.smalltools.tools.AbstractBasics;
import com.foilen.smalltools.tools.AssertTools;
import com.foilen.smalltools.tools.FileTools;
import com.foilen.smalltools.tools.JsonTools;
import com.foilen.smalltools.tools.StringTools;
import com.foilen.smalltools.trigger.SmoothTrigger;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;

public abstract class AbstractSingleJsonFileDao<T>
extends AbstractBasics {
    private String previousMd5sum;
    private T cached;
    private ReentrantLock transactionLock = new ReentrantLock();
    protected Runnable saveToFile = () -> {
        String cachedMd5sum = HashMd5sum.hashString(JsonTools.prettyPrint(this.cached));
        if (StringTools.safeEquals(this.previousMd5sum, cachedMd5sum)) {
            this.logger.debug("Content didn't change. Skipping saving");
            return;
        }
        if (this.cached == null) {
            this.logger.debug("Content wasn't loaded yet. Skipping saving");
            return;
        }
        this.logger.debug("Saving to {}", (Object)this.getFinalFile().getAbsolutePath());
        RenamingOnCloseOutputStreamWrapper out = FileTools.createStagingFile(this.getStagingFile(), this.getFinalFile(), true);
        try {
            JsonTools.writeToStream(out, this.cached);
            out.flush();
            out.setDeleteOnClose(false);
            out.close();
            this.previousMd5sum = cachedMd5sum;
        }
        catch (IOException e) {
            this.logger.error("Could not close the staging file {}", (Object)this.getStagingFile().getAbsolutePath(), (Object)e);
        }
    };
    private SmoothTrigger saveSmoothTrigger = new SmoothTrigger(2000L, 10000L, false, this.saveToFile).start();

    public synchronized void flush() {
        this.saveToFile.run();
    }

    protected abstract File getFinalFile();

    protected abstract File getStagingFile();

    protected abstract Class<T> getType();

    @PostConstruct
    public synchronized void init() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.flush()));
    }

    public T load() {
        this.transactionLock.lock();
        try {
            if (this.cached != null) {
                this.logger.debug("Return cached");
                T t = JsonTools.clone(this.cached);
                return t;
            }
            if (this.getFinalFile().exists()) {
                this.logger.debug("Loading from file");
                String json = FileTools.getFileAsString(this.getFinalFile());
                this.cached = JsonTools.readFromString(json, this.getType());
                if (this.cached == null) {
                    this.logger.debug("Loaded null");
                    this.cached = ReflectionTools.instantiate(this.getType(), new Object[0]);
                }
                this.previousMd5sum = HashMd5sum.hashString(json);
                T t = JsonTools.clone(this.cached);
                return t;
            }
            this.logger.debug("New state");
            this.cached = ReflectionTools.instantiate(this.getType(), new Object[0]);
            T t = ReflectionTools.instantiate(this.getType(), new Object[0]);
            return t;
        }
        finally {
            this.transactionLock.unlock();
        }
    }

    public void loadInTransaction(Consumer<T> execution) {
        AssertTools.assertFalse(this.transactionLock.isHeldByCurrentThread(), "Nested transactions are not supported");
        this.transactionLock.lock();
        try {
            T entity = this.load();
            execution.accept(entity);
            this.save(entity);
        }
        finally {
            this.transactionLock.unlock();
        }
    }

    public void save(T entity) {
        this.transactionLock.lock();
        try {
            this.cached = JsonTools.clone(entity);
            this.saveSmoothTrigger.request();
        }
        finally {
            this.transactionLock.unlock();
        }
    }
}

