/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.db;

import com.foilen.smalltools.hash.HashMd5sum;
import com.foilen.smalltools.streamwrapper.RenamingOnCloseOutputStreamWrapper;
import com.foilen.smalltools.tools.AbstractBasics;
import com.foilen.smalltools.tools.FileTools;
import com.foilen.smalltools.tools.JsonTools;
import com.foilen.smalltools.tools.StringTools;
import com.foilen.smalltools.trigger.SmoothTrigger;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;

public abstract class AbstractListSingleJsonFileDao<T, K>
extends AbstractBasics {
    private String previousMd5sum;
    private List<T> cachedEntities;
    protected Runnable saveToFile = () -> {
        String cachedMd5sum = HashMd5sum.hashString(JsonTools.prettyPrint(this.cachedEntities));
        if (StringTools.safeEquals(this.previousMd5sum, cachedMd5sum)) {
            this.logger.debug("Content didn't change. Skipping saving");
            return;
        }
        this.logger.debug("Saving to {}", (Object)this.getFinalFile().getAbsolutePath());
        RenamingOnCloseOutputStreamWrapper out = FileTools.createStagingFile(this.getStagingFile(), this.getFinalFile());
        JsonTools.writeToStream(out, this.cachedEntities);
        try {
            ((OutputStream)out).close();
            this.previousMd5sum = cachedMd5sum;
        }
        catch (IOException e) {
            this.logger.error("Could not close the staging file {}", (Object)this.getStagingFile().getAbsolutePath(), (Object)e);
        }
    };
    private SmoothTrigger saveSmoothTrigger = new SmoothTrigger(2000L, 10000L, false, this.saveToFile).start();

    public synchronized void add(Iterable<T> entities) {
        entities.forEach(it -> this.add(it));
    }

    public synchronized void add(T entity) {
        this.cachedEntities.add(JsonTools.clone(entity));
        this.saveSmoothTrigger.request();
    }

    public synchronized int count() {
        return this.cachedEntities.size();
    }

    public synchronized boolean delete(K key) {
        return this.delete(entity -> this.isEntity(key, entity)) > 0;
    }

    public synchronized int delete(Predicate<? super T> predicate) {
        int count = 0;
        Iterator<T> it = this.cachedEntities.iterator();
        while (it.hasNext()) {
            T next = it.next();
            if (!predicate.test(next)) continue;
            ++count;
            it.remove();
        }
        if (count > 0) {
            this.saveSmoothTrigger.request();
        }
        return count;
    }

    public List<T> findAllAsList() {
        return this.findAllAsStream().collect(Collectors.toList());
    }

    public synchronized List<T> findAllAsList(Predicate<? super T> predicate) {
        return this.findAllAsStream(predicate).collect(Collectors.toList());
    }

    public synchronized Stream<T> findAllAsStream() {
        return this.cachedEntities.stream().map(it -> JsonTools.clone(it));
    }

    public synchronized Stream<T> findAllAsStream(Predicate<? super T> predicate) {
        return this.cachedEntities.stream().filter(predicate).map(it -> JsonTools.clone(it));
    }

    public synchronized Optional<T> findOne(K key) {
        return this.findOne(entity -> this.isEntity(key, entity));
    }

    public synchronized Optional<T> findOne(Predicate<? super T> predicate) {
        return this.cachedEntities.stream().filter(predicate).map(it -> JsonTools.clone(it)).findAny();
    }

    public synchronized void flush() {
        this.saveToFile.run();
    }

    protected abstract File getFinalFile();

    protected abstract File getStagingFile();

    protected abstract Class<T> getType();

    @PostConstruct
    public synchronized void init() {
        if (this.load()) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.flush()));
        }
    }

    protected abstract boolean isEntity(K var1, T var2);

    private synchronized boolean load() {
        if (this.cachedEntities != null) {
            return false;
        }
        if (this.getFinalFile().exists()) {
            this.logger.debug("Loading from file");
            String json = FileTools.getFileAsString(this.getFinalFile());
            this.cachedEntities = JsonTools.readFromStringAsList(json, this.getType());
            this.previousMd5sum = HashMd5sum.hashString(json);
        } else {
            this.logger.debug("New state");
            this.cachedEntities = new ArrayList<T>();
        }
        return true;
    }

    public synchronized void update(K key, T entity) {
        this.delete(key);
        this.add(entity);
    }
}

