/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.compress;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.tools.AssertTools;
import com.foilen.smalltools.tools.CharsetTools;
import com.foilen.smalltools.tools.StreamsTools;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipFiles {
    private ZipOutputStream zos;

    public ZipFiles(File zipFile) {
        try {
            this.zos = new ZipOutputStream(new FileOutputStream(zipFile));
        }
        catch (FileNotFoundException e) {
            throw new SmallToolsException("Could not create the zip", e);
        }
    }

    public ZipFiles(OutputStream outputStream) {
        this.zos = new ZipOutputStream(outputStream);
    }

    public void addDirectory(String directoryName, File directory) {
        AssertTools.assertTrue(directory.exists(), "The directory does not exists");
        AssertTools.assertTrue(directory.isDirectory(), "The directory is not a directory");
        if (!((String)directoryName).endsWith("/")) {
            directoryName = (String)directoryName + "/";
        }
        for (File entry : directory.listFiles()) {
            String entryName = (String)directoryName + entry.getName();
            if (entry.isFile()) {
                this.addFile(entryName, entry);
                continue;
            }
            if (!entry.isDirectory()) continue;
            this.addDirectory(entryName, entry);
        }
    }

    public void addFile(String filename, File file) {
        try {
            this.addFileFromStream(filename, new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new SmallToolsException("The file to zip does not exists", e);
        }
    }

    public void addFileFromResource(String filename, String resource) {
        this.addFileFromStream(filename, ZipFiles.class.getResourceAsStream(resource));
    }

    public void addFileFromStream(String filename, InputStream inputStream) {
        try {
            ZipEntry ze = new ZipEntry(filename);
            this.zos.putNextEntry(ze);
            StreamsTools.flowStream(inputStream, this.zos);
            this.zos.closeEntry();
        }
        catch (IOException e) {
            throw new SmallToolsException("Problem creating the zip file", e);
        }
    }

    public void addFileFromUrl(String filename, String url) {
        try {
            this.addFileFromUrl(filename, new URL(url));
        }
        catch (MalformedURLException e) {
            throw new SmallToolsException("The url is invalid", e);
        }
    }

    public void addFileFromUrl(String filename, URL url) {
        try {
            this.addFileFromStream(filename, url.openStream());
        }
        catch (IOException e) {
            throw new SmallToolsException("Problem reading the URL", e);
        }
    }

    public void addTextFile(String filename, String content) {
        this.addFileFromStream(filename, new ByteArrayInputStream(content.getBytes(CharsetTools.UTF_8)));
    }

    public void close() {
        try {
            this.zos.close();
        }
        catch (IOException e) {
            throw new SmallToolsException("Problem closing the zip file", e);
        }
    }

    public void setCompressionLevel(int level) {
        this.zos.setLevel(level);
    }
}

