/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.tools.AssertTools;
import com.foilen.smalltools.tools.CharsetTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XslTransform {
    private static final TransformerFactory FACTORY = TransformerFactory.newInstance();
    private Transformer transformer;
    private StreamSource fromXml;

    private void assertFields() {
        AssertTools.assertNotNull(this.transformer, "XSL not set. Call any using* methods prior");
        AssertTools.assertNotNull(this.fromXml, "XML not set. Call any from* methods prior");
    }

    public XslTransform fromFile(File xmlFile) {
        try {
            this.fromXml = new StreamSource(xmlFile);
            return this;
        }
        catch (Exception e) {
            throw new SmallToolsException(e);
        }
    }

    public XslTransform fromFile(String xmlPathName) {
        try {
            return this.fromInputStream(new FileInputStream(xmlPathName));
        }
        catch (Exception e) {
            throw new SmallToolsException(e);
        }
    }

    public XslTransform fromInputStream(InputStream xmlInputStream) {
        this.fromXml = new StreamSource(xmlInputStream);
        return this;
    }

    public XslTransform fromResource(String xmlResourcePath) {
        return this.fromInputStream(this.getClass().getResourceAsStream(xmlResourcePath));
    }

    public XslTransform fromText(String xmlContent) {
        return this.fromInputStream(new ByteArrayInputStream(xmlContent.getBytes(CharsetTools.UTF_8)));
    }

    public XslTransform fromUrl(String xmlUrl) {
        try {
            this.fromXml = new StreamSource(xmlUrl);
            return this;
        }
        catch (Exception e) {
            throw new SmallToolsException(e);
        }
    }

    public void toFile(File xmlFile) {
        this.assertFields();
        try {
            StreamResult out = new StreamResult(xmlFile);
            this.transformer.transform(this.fromXml, out);
        }
        catch (Exception e) {
            throw new SmallToolsException(e);
        }
    }

    public void toFile(String xmlPathName) {
        this.assertFields();
        try {
            this.toOutputStream(new FileOutputStream(xmlPathName));
        }
        catch (Exception e) {
            throw new SmallToolsException(e);
        }
    }

    public void toOutputStream(OutputStream xmlOutputStream) {
        this.assertFields();
        try {
            StreamResult out = new StreamResult(xmlOutputStream);
            this.transformer.transform(this.fromXml, out);
        }
        catch (Exception e) {
            throw new SmallToolsException(e);
        }
    }

    public String toText() {
        this.assertFields();
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.toOutputStream(outputStream);
            return new String(outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new SmallToolsException(e);
        }
    }

    public void toWriter(Writer xmlWriter) {
        this.assertFields();
        try {
            StreamResult out = new StreamResult(xmlWriter);
            this.transformer.transform(this.fromXml, out);
        }
        catch (Exception e) {
            throw new SmallToolsException(e);
        }
    }

    public XslTransform usingFile(File xslFile) {
        try {
            this.transformer = FACTORY.newTransformer(new StreamSource(xslFile));
            return this;
        }
        catch (TransformerConfigurationException e) {
            throw new SmallToolsException(e);
        }
    }

    public XslTransform usingFile(String xslPathName) {
        try {
            this.transformer = FACTORY.newTransformer(new StreamSource(new File(xslPathName)));
            return this;
        }
        catch (TransformerConfigurationException e) {
            throw new SmallToolsException(e);
        }
    }

    public XslTransform usingInputStream(InputStream xslInputStream) {
        try {
            this.transformer = FACTORY.newTransformer(new StreamSource(xslInputStream));
            return this;
        }
        catch (TransformerConfigurationException e) {
            throw new SmallToolsException(e);
        }
    }

    public XslTransform usingReader(Reader xslReader) {
        try {
            this.transformer = FACTORY.newTransformer(new StreamSource(xslReader));
            return this;
        }
        catch (TransformerConfigurationException e) {
            throw new SmallToolsException(e);
        }
    }

    public XslTransform usingResource(String xslResourcePath) {
        return this.usingInputStream(this.getClass().getResourceAsStream(xslResourcePath));
    }

    public XslTransform usingText(String xslContent) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xslContent.getBytes(CharsetTools.UTF_8));
        return this.usingInputStream(inputStream);
    }

    public XslTransform usingUrl(String xslUrl) {
        try {
            this.transformer = FACTORY.newTransformer(new StreamSource(xslUrl));
            return this;
        }
        catch (TransformerConfigurationException e) {
            throw new SmallToolsException(e);
        }
    }
}

