/*
 * Decompiled with CFR 0.152.
 */
package com.xiaopo.flying.puzzle.straight;

import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import com.xiaopo.flying.puzzle.Area;
import com.xiaopo.flying.puzzle.Line;
import com.xiaopo.flying.puzzle.straight.StraightLine;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

class StraightArea
implements Area {
    StraightLine lineLeft;
    StraightLine lineTop;
    StraightLine lineRight;
    StraightLine lineBottom;
    private Path areaPath = new Path();
    private RectF areaRect = new RectF();
    private PointF[] handleBarPoints = new PointF[2];
    private float paddingLeft;
    private float paddingTop;
    private float paddingRight;
    private float paddingBottom;
    private float radian;

    StraightArea() {
        this.handleBarPoints[0] = new PointF();
        this.handleBarPoints[1] = new PointF();
    }

    StraightArea(RectF baseRect) {
        this();
        this.setBaseRect(baseRect);
    }

    private void setBaseRect(RectF baseRect) {
        PointF one = new PointF(baseRect.left, baseRect.top);
        PointF two = new PointF(baseRect.right, baseRect.top);
        PointF three = new PointF(baseRect.left, baseRect.bottom);
        PointF four = new PointF(baseRect.right, baseRect.bottom);
        this.lineLeft = new StraightLine(one, three);
        this.lineTop = new StraightLine(one, two);
        this.lineRight = new StraightLine(two, four);
        this.lineBottom = new StraightLine(three, four);
    }

    StraightArea(StraightArea src) {
        this.lineLeft = src.lineLeft;
        this.lineTop = src.lineTop;
        this.lineRight = src.lineRight;
        this.lineBottom = src.lineBottom;
        this.handleBarPoints[0] = new PointF();
        this.handleBarPoints[1] = new PointF();
    }

    @Override
    public float left() {
        return this.lineLeft.minX() + this.paddingLeft;
    }

    @Override
    public float top() {
        return this.lineTop.minY() + this.paddingTop;
    }

    @Override
    public float right() {
        return this.lineRight.maxX() - this.paddingRight;
    }

    @Override
    public float bottom() {
        return this.lineBottom.maxY() - this.paddingBottom;
    }

    @Override
    public float centerX() {
        return (this.left() + this.right()) / 2.0f;
    }

    @Override
    public float centerY() {
        return (this.top() + this.bottom()) / 2.0f;
    }

    @Override
    public float width() {
        return this.right() - this.left();
    }

    @Override
    public float height() {
        return this.bottom() - this.top();
    }

    @Override
    public PointF getCenterPoint() {
        return new PointF(this.centerX(), this.centerY());
    }

    @Override
    public boolean contains(PointF point) {
        return this.contains(point.x, point.y);
    }

    @Override
    public boolean contains(float x, float y) {
        return this.getAreaRect().contains(x, y);
    }

    @Override
    public boolean contains(Line line) {
        return this.lineLeft == line || this.lineTop == line || this.lineRight == line || this.lineBottom == line;
    }

    @Override
    public Path getAreaPath() {
        this.areaPath.reset();
        this.areaPath.addRoundRect(this.getAreaRect(), this.radian, this.radian, Path.Direction.CCW);
        return this.areaPath;
    }

    @Override
    public RectF getAreaRect() {
        this.areaRect.set(this.left(), this.top(), this.right(), this.bottom());
        return this.areaRect;
    }

    @Override
    public List<Line> getLines() {
        return Arrays.asList(this.lineLeft, this.lineTop, this.lineRight, this.lineBottom);
    }

    @Override
    public PointF[] getHandleBarPoints(Line line) {
        if (line == this.lineLeft) {
            this.handleBarPoints[0].x = this.left();
            this.handleBarPoints[0].y = this.top() + this.height() / 4.0f;
            this.handleBarPoints[1].x = this.left();
            this.handleBarPoints[1].y = this.top() + this.height() / 4.0f * 3.0f;
        } else if (line == this.lineTop) {
            this.handleBarPoints[0].x = this.left() + this.width() / 4.0f;
            this.handleBarPoints[0].y = this.top();
            this.handleBarPoints[1].x = this.left() + this.width() / 4.0f * 3.0f;
            this.handleBarPoints[1].y = this.top();
        } else if (line == this.lineRight) {
            this.handleBarPoints[0].x = this.right();
            this.handleBarPoints[0].y = this.top() + this.height() / 4.0f;
            this.handleBarPoints[1].x = this.right();
            this.handleBarPoints[1].y = this.top() + this.height() / 4.0f * 3.0f;
        } else if (line == this.lineBottom) {
            this.handleBarPoints[0].x = this.left() + this.width() / 4.0f;
            this.handleBarPoints[0].y = this.bottom();
            this.handleBarPoints[1].x = this.left() + this.width() / 4.0f * 3.0f;
            this.handleBarPoints[1].y = this.bottom();
        }
        return this.handleBarPoints;
    }

    @Override
    public float radian() {
        return this.radian;
    }

    @Override
    public void setRadian(float radian) {
        this.radian = radian;
    }

    @Override
    public float getPaddingLeft() {
        return this.paddingLeft;
    }

    @Override
    public float getPaddingTop() {
        return this.paddingTop;
    }

    @Override
    public float getPaddingRight() {
        return this.paddingRight;
    }

    @Override
    public float getPaddingBottom() {
        return this.paddingBottom;
    }

    @Override
    public void setPadding(float padding) {
        this.setPadding(padding, padding, padding, padding);
    }

    @Override
    public void setPadding(float paddingLeft, float paddingTop, float paddingRight, float paddingBottom) {
        this.paddingLeft = paddingLeft;
        this.paddingTop = paddingTop;
        this.paddingRight = paddingRight;
        this.paddingBottom = paddingBottom;
    }

    static class AreaComparator
    implements Comparator<StraightArea> {
        AreaComparator() {
        }

        @Override
        public int compare(StraightArea lhs, StraightArea rhs) {
            if (lhs.top() < rhs.top()) {
                return -1;
            }
            if (lhs.top() == rhs.top()) {
                if (lhs.left() < rhs.left()) {
                    return -1;
                }
                return 1;
            }
            return 1;
        }
    }
}

