/*
 * Decompiled with CFR 0.152.
 */
package com.xiaopo.flying.puzzle.slant;

import android.graphics.PointF;
import android.util.Pair;
import com.xiaopo.flying.puzzle.Line;
import com.xiaopo.flying.puzzle.slant.CrossoverPointF;
import com.xiaopo.flying.puzzle.slant.SlantArea;
import com.xiaopo.flying.puzzle.slant.SlantLine;
import java.util.ArrayList;
import java.util.List;

class SlantUtils {
    private static final PointF A = new PointF();
    private static final PointF B = new PointF();
    private static final PointF C = new PointF();
    private static final PointF D = new PointF();
    private static final PointF AB = new PointF();
    private static final PointF AM = new PointF();
    private static final PointF BC = new PointF();
    private static final PointF BM = new PointF();
    private static final PointF CD = new PointF();
    private static final PointF CM = new PointF();
    private static final PointF DA = new PointF();
    private static final PointF DM = new PointF();

    private SlantUtils() {
    }

    static float distance(PointF one, PointF two) {
        return (float)Math.sqrt(Math.pow(two.x - one.x, 2.0) + Math.pow(two.y - one.y, 2.0));
    }

    static List<SlantArea> cutAreaWith(SlantArea area, SlantLine line) {
        ArrayList<SlantArea> areas = new ArrayList<SlantArea>();
        SlantArea area1 = new SlantArea(area);
        SlantArea area2 = new SlantArea(area);
        if (line.direction == Line.Direction.HORIZONTAL) {
            area1.lineBottom = line;
            area1.leftBottom = line.start;
            area1.rightBottom = line.end;
            area2.lineTop = line;
            area2.leftTop = line.start;
            area2.rightTop = line.end;
        } else {
            area1.lineRight = line;
            area1.rightTop = line.start;
            area1.rightBottom = line.end;
            area2.lineLeft = line;
            area2.leftTop = line.start;
            area2.leftBottom = line.end;
        }
        areas.add(area1);
        areas.add(area2);
        return areas;
    }

    static SlantLine createLine(SlantArea area, Line.Direction direction, float startratio, float endratio) {
        SlantLine line = new SlantLine(direction);
        if (direction == Line.Direction.HORIZONTAL) {
            line.start = SlantUtils.getPoint(area.leftTop, area.leftBottom, Line.Direction.VERTICAL, startratio);
            line.end = SlantUtils.getPoint(area.rightTop, area.rightBottom, Line.Direction.VERTICAL, endratio);
            line.attachLineStart = area.lineLeft;
            line.attachLineEnd = area.lineRight;
            line.upperLine = area.lineBottom;
            line.lowerLine = area.lineTop;
        } else {
            line.start = SlantUtils.getPoint(area.leftTop, area.rightTop, Line.Direction.HORIZONTAL, startratio);
            line.end = SlantUtils.getPoint(area.leftBottom, area.rightBottom, Line.Direction.HORIZONTAL, endratio);
            line.attachLineStart = area.lineTop;
            line.attachLineEnd = area.lineBottom;
            line.upperLine = area.lineRight;
            line.lowerLine = area.lineLeft;
        }
        return line;
    }

    static Pair<List<SlantLine>, List<SlantArea>> cutAreaWith(SlantArea area, int horizontalSize, int verticalSize) {
        ArrayList<SlantArea> areaList = new ArrayList<SlantArea>();
        ArrayList<SlantLine> horizontalLines = new ArrayList<SlantLine>(horizontalSize);
        SlantArea restArea = new SlantArea(area);
        for (int i = horizontalSize + 1; i > 1; --i) {
            SlantLine horizontalLine = SlantUtils.createLine(restArea, Line.Direction.HORIZONTAL, (float)(i - 1) / (float)i - 0.025f, (float)(i - 1) / (float)i + 0.025f);
            horizontalLines.add(horizontalLine);
            restArea.lineBottom = horizontalLine;
            restArea.leftBottom = horizontalLine.start;
            restArea.rightBottom = horizontalLine.end;
        }
        ArrayList<SlantLine> verticalLines = new ArrayList<SlantLine>();
        restArea = new SlantArea(area);
        for (int i = verticalSize + 1; i > 1; --i) {
            SlantLine verticalLine = SlantUtils.createLine(restArea, Line.Direction.VERTICAL, (float)(i - 1) / (float)i + 0.025f, (float)(i - 1) / (float)i - 0.025f);
            verticalLines.add(verticalLine);
            SlantArea spiltArea = new SlantArea(restArea);
            spiltArea.lineLeft = verticalLine;
            spiltArea.leftTop = verticalLine.start;
            spiltArea.leftBottom = verticalLine.end;
            for (int j = 0; j <= horizontalLines.size(); ++j) {
                SlantArea blockArea = new SlantArea(spiltArea);
                if (j == 0) {
                    blockArea.lineTop = (SlantLine)horizontalLines.get(j);
                } else if (j == horizontalLines.size()) {
                    blockArea.lineBottom = (SlantLine)horizontalLines.get(j - 1);
                    CrossoverPointF leftBottom = new CrossoverPointF(blockArea.lineBottom, blockArea.lineLeft);
                    SlantUtils.intersectionOfLines(leftBottom, blockArea.lineBottom, blockArea.lineLeft);
                    CrossoverPointF rightBottom = new CrossoverPointF(blockArea.lineBottom, blockArea.lineRight);
                    SlantUtils.intersectionOfLines(rightBottom, blockArea.lineBottom, blockArea.lineRight);
                    blockArea.leftBottom = leftBottom;
                    blockArea.rightBottom = rightBottom;
                } else {
                    blockArea.lineTop = (SlantLine)horizontalLines.get(j);
                    blockArea.lineBottom = (SlantLine)horizontalLines.get(j - 1);
                }
                CrossoverPointF leftTop = new CrossoverPointF(blockArea.lineTop, blockArea.lineLeft);
                SlantUtils.intersectionOfLines(leftTop, blockArea.lineTop, blockArea.lineLeft);
                CrossoverPointF rightTop = new CrossoverPointF(blockArea.lineTop, blockArea.lineRight);
                SlantUtils.intersectionOfLines(rightTop, blockArea.lineTop, blockArea.lineRight);
                blockArea.leftTop = leftTop;
                blockArea.rightTop = rightTop;
                areaList.add(blockArea);
            }
            restArea.lineRight = verticalLine;
            restArea.rightTop = verticalLine.start;
            restArea.rightBottom = verticalLine.end;
        }
        for (int j = 0; j <= horizontalLines.size(); ++j) {
            SlantArea blockArea = new SlantArea(restArea);
            if (j == 0) {
                blockArea.lineTop = (SlantLine)horizontalLines.get(j);
            } else if (j == horizontalLines.size()) {
                blockArea.lineBottom = (SlantLine)horizontalLines.get(j - 1);
                CrossoverPointF leftBottom = new CrossoverPointF(blockArea.lineBottom, blockArea.lineLeft);
                SlantUtils.intersectionOfLines(leftBottom, blockArea.lineBottom, blockArea.lineLeft);
                CrossoverPointF rightBottom = new CrossoverPointF(blockArea.lineBottom, blockArea.lineRight);
                SlantUtils.intersectionOfLines(rightBottom, blockArea.lineBottom, blockArea.lineRight);
                blockArea.leftBottom = leftBottom;
                blockArea.rightBottom = rightBottom;
            } else {
                blockArea.lineTop = (SlantLine)horizontalLines.get(j);
                blockArea.lineBottom = (SlantLine)horizontalLines.get(j - 1);
            }
            CrossoverPointF leftTop = new CrossoverPointF(blockArea.lineTop, blockArea.lineLeft);
            SlantUtils.intersectionOfLines(leftTop, blockArea.lineTop, blockArea.lineLeft);
            CrossoverPointF rightTop = new CrossoverPointF(blockArea.lineTop, blockArea.lineRight);
            SlantUtils.intersectionOfLines(rightTop, blockArea.lineTop, blockArea.lineRight);
            blockArea.leftTop = leftTop;
            blockArea.rightTop = rightTop;
            areaList.add(blockArea);
        }
        ArrayList<SlantLine> lines = new ArrayList<SlantLine>();
        lines.addAll(horizontalLines);
        lines.addAll(verticalLines);
        return new Pair(lines, areaList);
    }

    static List<SlantArea> cutAreaCross(SlantArea area, SlantLine horizontal, SlantLine vertical) {
        ArrayList<SlantArea> list = new ArrayList<SlantArea>();
        CrossoverPointF crossoverPoint = new CrossoverPointF(horizontal, vertical);
        SlantUtils.intersectionOfLines(crossoverPoint, horizontal, vertical);
        SlantArea one = new SlantArea(area);
        one.lineBottom = horizontal;
        one.lineRight = vertical;
        one.rightTop = vertical.start;
        one.rightBottom = crossoverPoint;
        one.leftBottom = horizontal.start;
        list.add(one);
        SlantArea two = new SlantArea(area);
        two.lineBottom = horizontal;
        two.lineLeft = vertical;
        two.leftTop = vertical.start;
        two.rightBottom = horizontal.end;
        two.leftBottom = crossoverPoint;
        list.add(two);
        SlantArea three = new SlantArea(area);
        three.lineTop = horizontal;
        three.lineRight = vertical;
        three.leftTop = horizontal.start;
        three.rightTop = crossoverPoint;
        three.rightBottom = vertical.end;
        list.add(three);
        SlantArea four = new SlantArea(area);
        four.lineTop = horizontal;
        four.lineLeft = vertical;
        four.leftTop = crossoverPoint;
        four.rightTop = horizontal.end;
        four.leftBottom = vertical.end;
        list.add(four);
        return list;
    }

    private static CrossoverPointF getPoint(PointF start, PointF end, Line.Direction direction, float ratio) {
        CrossoverPointF point = new CrossoverPointF();
        SlantUtils.getPoint(point, start, end, direction, ratio);
        return point;
    }

    static void getPoint(PointF dst, PointF start, PointF end, Line.Direction direction, float ratio) {
        float deltaY = Math.abs(start.y - end.y);
        float deltaX = Math.abs(start.x - end.x);
        float maxY = Math.max(start.y, end.y);
        float minY = Math.min(start.y, end.y);
        float maxX = Math.max(start.x, end.x);
        float minX = Math.min(start.x, end.x);
        if (direction == Line.Direction.HORIZONTAL) {
            dst.x = minX + deltaX * ratio;
            dst.y = start.y < end.y ? minY + ratio * deltaY : maxY - ratio * deltaY;
        } else {
            dst.y = minY + deltaY * ratio;
            dst.x = start.x < end.x ? minX + ratio * deltaX : maxX - ratio * deltaX;
        }
    }

    private static float crossProduct(PointF a, PointF b) {
        return a.x * b.y - b.x * a.y;
    }

    static boolean contains(SlantArea area, float x, float y) {
        SlantUtils.AB.x = area.rightTop.x - area.leftTop.x;
        SlantUtils.AB.y = area.rightTop.y - area.leftTop.y;
        SlantUtils.AM.x = x - area.leftTop.x;
        SlantUtils.AM.y = y - area.leftTop.y;
        SlantUtils.BC.x = area.rightBottom.x - area.rightTop.x;
        SlantUtils.BC.y = area.rightBottom.y - area.rightTop.y;
        SlantUtils.BM.x = x - area.rightTop.x;
        SlantUtils.BM.y = y - area.rightTop.y;
        SlantUtils.CD.x = area.leftBottom.x - area.rightBottom.x;
        SlantUtils.CD.y = area.leftBottom.y - area.rightBottom.y;
        SlantUtils.CM.x = x - area.rightBottom.x;
        SlantUtils.CM.y = y - area.rightBottom.y;
        SlantUtils.DA.x = area.leftTop.x - area.leftBottom.x;
        SlantUtils.DA.y = area.leftTop.y - area.leftBottom.y;
        SlantUtils.DM.x = x - area.leftBottom.x;
        SlantUtils.DM.y = y - area.leftBottom.y;
        return SlantUtils.crossProduct(AB, AM) > 0.0f && SlantUtils.crossProduct(BC, BM) > 0.0f && SlantUtils.crossProduct(CD, CM) > 0.0f && SlantUtils.crossProduct(DA, DM) > 0.0f;
    }

    static boolean contains(SlantLine line, float x, float y, float extra) {
        CrossoverPointF start = line.start;
        CrossoverPointF end = line.end;
        if (line.direction == Line.Direction.VERTICAL) {
            SlantUtils.A.x = start.x - extra;
            SlantUtils.A.y = start.y;
            SlantUtils.B.x = start.x + extra;
            SlantUtils.B.y = start.y;
            SlantUtils.C.x = end.x + extra;
            SlantUtils.C.y = end.y;
            SlantUtils.D.x = end.x - extra;
            SlantUtils.D.y = end.y;
        } else {
            SlantUtils.A.x = start.x;
            SlantUtils.A.y = start.y - extra;
            SlantUtils.B.x = end.x;
            SlantUtils.B.y = end.y - extra;
            SlantUtils.C.x = end.x;
            SlantUtils.C.y = end.y + extra;
            SlantUtils.D.x = start.x;
            SlantUtils.D.y = start.y + extra;
        }
        SlantUtils.AB.x = SlantUtils.B.x - SlantUtils.A.x;
        SlantUtils.AB.y = SlantUtils.B.y - SlantUtils.A.y;
        SlantUtils.AM.x = x - SlantUtils.A.x;
        SlantUtils.AM.y = y - SlantUtils.A.y;
        SlantUtils.BC.x = SlantUtils.C.x - SlantUtils.B.x;
        SlantUtils.BC.y = SlantUtils.C.y - SlantUtils.B.y;
        SlantUtils.BM.x = x - SlantUtils.B.x;
        SlantUtils.BM.y = y - SlantUtils.B.y;
        SlantUtils.CD.x = SlantUtils.D.x - SlantUtils.C.x;
        SlantUtils.CD.y = SlantUtils.D.y - SlantUtils.C.y;
        SlantUtils.CM.x = x - SlantUtils.C.x;
        SlantUtils.CM.y = y - SlantUtils.C.y;
        SlantUtils.DA.x = SlantUtils.A.x - SlantUtils.D.x;
        SlantUtils.DA.y = SlantUtils.A.y - SlantUtils.D.y;
        SlantUtils.DM.x = x - SlantUtils.D.x;
        SlantUtils.DM.y = y - SlantUtils.D.y;
        return SlantUtils.crossProduct(AB, AM) > 0.0f && SlantUtils.crossProduct(BC, BM) > 0.0f && SlantUtils.crossProduct(CD, CM) > 0.0f && SlantUtils.crossProduct(DA, DM) > 0.0f;
    }

    static void intersectionOfLines(CrossoverPointF dst, SlantLine lineOne, SlantLine lineTwo) {
        dst.horizontal = lineOne;
        dst.vertical = lineTwo;
        if (SlantUtils.isParallel(lineOne, lineTwo)) {
            dst.set(0.0f, 0.0f);
            return;
        }
        if (SlantUtils.isHorizontalLine(lineOne) && SlantUtils.isVerticalLine(lineTwo)) {
            dst.set(lineTwo.start.x, lineOne.start.y);
            return;
        }
        if (SlantUtils.isVerticalLine(lineOne) && SlantUtils.isHorizontalLine(lineTwo)) {
            dst.set(lineOne.start.x, lineTwo.start.y);
            return;
        }
        if (SlantUtils.isHorizontalLine(lineOne) && !SlantUtils.isVerticalLine(lineTwo)) {
            float k = SlantUtils.calculateSlope(lineTwo);
            float b = SlantUtils.calculateVerticalIntercept(lineTwo);
            dst.y = lineOne.start.y;
            dst.x = (dst.y - b) / k;
            return;
        }
        if (SlantUtils.isVerticalLine(lineOne) && !SlantUtils.isHorizontalLine(lineTwo)) {
            float k = SlantUtils.calculateSlope(lineTwo);
            float b = SlantUtils.calculateVerticalIntercept(lineTwo);
            dst.x = lineOne.start.x;
            dst.y = k * dst.x + b;
            return;
        }
        if (SlantUtils.isHorizontalLine(lineTwo) && !SlantUtils.isVerticalLine(lineOne)) {
            float k = SlantUtils.calculateSlope(lineOne);
            float b = SlantUtils.calculateVerticalIntercept(lineOne);
            dst.y = lineTwo.start.y;
            dst.x = (dst.y - b) / k;
            return;
        }
        if (SlantUtils.isVerticalLine(lineTwo) && !SlantUtils.isHorizontalLine(lineOne)) {
            float k = SlantUtils.calculateSlope(lineOne);
            float b = SlantUtils.calculateVerticalIntercept(lineOne);
            dst.x = lineTwo.start.x;
            dst.y = k * dst.x + b;
            return;
        }
        float k1 = SlantUtils.calculateSlope(lineOne);
        float b1 = SlantUtils.calculateVerticalIntercept(lineOne);
        float k2 = SlantUtils.calculateSlope(lineTwo);
        float b2 = SlantUtils.calculateVerticalIntercept(lineTwo);
        dst.x = (b2 - b1) / (k1 - k2);
        dst.y = dst.x * k1 + b1;
    }

    private static boolean isHorizontalLine(SlantLine line) {
        return line.start.y == line.end.y;
    }

    private static boolean isVerticalLine(SlantLine line) {
        return line.start.x == line.end.x;
    }

    private static boolean isParallel(SlantLine lineOne, SlantLine lineTwo) {
        return SlantUtils.calculateSlope(lineOne) == SlantUtils.calculateSlope(lineTwo);
    }

    static float calculateSlope(SlantLine line) {
        if (SlantUtils.isHorizontalLine(line)) {
            return 0.0f;
        }
        if (SlantUtils.isVerticalLine(line)) {
            return Float.POSITIVE_INFINITY;
        }
        return (line.start.y - line.end.y) / (line.start.x - line.end.x);
    }

    private static float calculateVerticalIntercept(SlantLine line) {
        if (SlantUtils.isHorizontalLine(line)) {
            return line.start.y;
        }
        if (SlantUtils.isVerticalLine(line)) {
            return Float.POSITIVE_INFINITY;
        }
        float k = SlantUtils.calculateSlope(line);
        return line.start.y - k * line.start.x;
    }
}

