/*
 * Decompiled with CFR 0.152.
 */
package com.xiaopo.flying.puzzle.slant;

import android.graphics.RectF;
import android.util.Pair;
import com.xiaopo.flying.puzzle.Area;
import com.xiaopo.flying.puzzle.Line;
import com.xiaopo.flying.puzzle.PuzzleLayout;
import com.xiaopo.flying.puzzle.slant.CrossoverPointF;
import com.xiaopo.flying.puzzle.slant.SlantArea;
import com.xiaopo.flying.puzzle.slant.SlantLine;
import com.xiaopo.flying.puzzle.slant.SlantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class SlantPuzzleLayout
implements PuzzleLayout {
    private RectF bounds;
    private SlantArea outerArea;
    private List<Line> outerLines = new ArrayList<Line>(4);
    private List<SlantArea> areas = new ArrayList<SlantArea>();
    private List<Line> lines = new ArrayList<Line>();
    private float padding;
    private float radian;
    private int color;
    private Comparator<SlantArea> areaComparator = new SlantArea.AreaComparator();
    private ArrayList<PuzzleLayout.Step> steps = new ArrayList();

    protected SlantPuzzleLayout() {
    }

    @Override
    public void setOuterBounds(RectF bounds) {
        this.reset();
        this.bounds = bounds;
        CrossoverPointF leftTop = new CrossoverPointF(bounds.left, bounds.top);
        CrossoverPointF rightTop = new CrossoverPointF(bounds.right, bounds.top);
        CrossoverPointF leftBottom = new CrossoverPointF(bounds.left, bounds.bottom);
        CrossoverPointF rightBottom = new CrossoverPointF(bounds.right, bounds.bottom);
        SlantLine lineLeft = new SlantLine(leftTop, leftBottom, Line.Direction.VERTICAL);
        SlantLine lineTop = new SlantLine(leftTop, rightTop, Line.Direction.HORIZONTAL);
        SlantLine lineRight = new SlantLine(rightTop, rightBottom, Line.Direction.VERTICAL);
        SlantLine lineBottom = new SlantLine(leftBottom, rightBottom, Line.Direction.HORIZONTAL);
        this.outerLines.clear();
        this.outerLines.add(lineLeft);
        this.outerLines.add(lineTop);
        this.outerLines.add(lineRight);
        this.outerLines.add(lineBottom);
        this.outerArea = new SlantArea();
        this.outerArea.lineLeft = lineLeft;
        this.outerArea.lineTop = lineTop;
        this.outerArea.lineRight = lineRight;
        this.outerArea.lineBottom = lineBottom;
        this.outerArea.updateCornerPoints();
        this.areas.clear();
        this.areas.add(this.outerArea);
    }

    @Override
    public abstract void layout();

    private void updateLineLimit() {
        for (int i = 0; i < this.lines.size(); ++i) {
            Line line = this.lines.get(i);
            this.updateUpperLine(line);
            this.updateLowerLine(line);
        }
    }

    private void updateLowerLine(Line line) {
        for (int i = 0; i < this.lines.size(); ++i) {
            Line l = this.lines.get(i);
            if (l.direction() != line.direction() || l.attachStartLine() != line.attachStartLine() || l.attachEndLine() != line.attachEndLine()) continue;
            if (l.direction() == Line.Direction.HORIZONTAL) {
                if (!(l.minY() > line.lowerLine().maxY()) || !(l.maxY() < line.minY())) continue;
                line.setLowerLine(l);
                continue;
            }
            if (!(l.minX() > line.lowerLine().maxX()) || !(l.maxX() < line.minX())) continue;
            line.setLowerLine(l);
        }
    }

    private void updateUpperLine(Line line) {
        for (int i = 0; i < this.lines.size(); ++i) {
            Line l = this.lines.get(i);
            if (l.direction() != line.direction() || l.attachStartLine() != line.attachStartLine() || l.attachEndLine() != line.attachEndLine()) continue;
            if (l.direction() == Line.Direction.HORIZONTAL) {
                if (!(l.maxY() < line.upperLine().minY()) || !(l.minY() > line.maxY())) continue;
                line.setUpperLine(l);
                continue;
            }
            if (!(l.maxX() < line.upperLine().minX()) || !(l.minX() > line.maxX())) continue;
            line.setUpperLine(l);
        }
    }

    @Override
    public int getAreaCount() {
        return this.areas.size();
    }

    @Override
    public void reset() {
        this.lines.clear();
        this.areas.clear();
        this.areas.add(this.outerArea);
        this.steps.clear();
    }

    @Override
    public void update() {
        int i;
        for (i = 0; i < this.lines.size(); ++i) {
            this.lines.get(i).update(this.width(), this.height());
        }
        for (i = 0; i < this.areas.size(); ++i) {
            this.areas.get(i).updateCornerPoints();
        }
    }

    @Override
    public float width() {
        return this.outerArea == null ? 0.0f : this.outerArea.width();
    }

    @Override
    public float height() {
        return this.outerArea == null ? 0.0f : this.outerArea.height();
    }

    private void sortAreas() {
        Collections.sort(this.areas, this.areaComparator);
    }

    @Override
    public List<Line> getOuterLines() {
        return this.outerLines;
    }

    @Override
    public Area getOuterArea() {
        return this.outerArea;
    }

    public List<SlantArea> getAreas() {
        return this.areas;
    }

    @Override
    public SlantArea getArea(int position) {
        return this.areas.get(position);
    }

    @Override
    public List<Line> getLines() {
        return this.lines;
    }

    @Override
    public void setPadding(float padding) {
        this.padding = padding;
        for (Area area : this.areas) {
            area.setPadding(padding);
        }
        this.outerArea.lineLeft.startPoint().set(this.bounds.left + padding, this.bounds.top + padding);
        this.outerArea.lineLeft.endPoint().set(this.bounds.left + padding, this.bounds.bottom - padding);
        this.outerArea.lineRight.startPoint().set(this.bounds.right - padding, this.bounds.top + padding);
        this.outerArea.lineRight.endPoint().set(this.bounds.right - padding, this.bounds.bottom - padding);
        this.outerArea.updateCornerPoints();
        this.update();
    }

    @Override
    public float getPadding() {
        return this.padding;
    }

    @Override
    public float getRadian() {
        return this.radian;
    }

    @Override
    public void setRadian(float radian) {
        this.radian = radian;
        for (Area area : this.areas) {
            area.setRadian(radian);
        }
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    protected List<SlantArea> addLine(int position, Line.Direction direction, float ratio) {
        return this.addLine(position, direction, ratio, ratio);
    }

    protected List<SlantArea> addLine(int position, Line.Direction direction, float startRatio, float endRatio) {
        SlantArea area = this.areas.get(position);
        this.areas.remove(area);
        SlantLine line = SlantUtils.createLine(area, direction, startRatio, endRatio);
        this.lines.add(line);
        List<SlantArea> increasedAreas = SlantUtils.cutAreaWith(area, line);
        this.areas.addAll(increasedAreas);
        this.updateLineLimit();
        this.sortAreas();
        PuzzleLayout.Step step = new PuzzleLayout.Step();
        step.type = 0;
        step.direction = direction == Line.Direction.HORIZONTAL ? 0 : 1;
        step.position = position;
        this.steps.add(step);
        return increasedAreas;
    }

    protected void addCross(int position, float startRatio1, float endRatio1, float startRatio2, float endRatio2) {
        SlantArea area = this.areas.get(position);
        this.areas.remove(area);
        SlantLine horizontal = SlantUtils.createLine(area, Line.Direction.HORIZONTAL, startRatio1, endRatio1);
        SlantLine vertical = SlantUtils.createLine(area, Line.Direction.VERTICAL, startRatio2, endRatio2);
        this.lines.add(horizontal);
        this.lines.add(vertical);
        List<SlantArea> increasedAreas = SlantUtils.cutAreaCross(area, horizontal, vertical);
        this.areas.addAll(increasedAreas);
        this.sortAreas();
        PuzzleLayout.Step step = new PuzzleLayout.Step();
        step.type = 1;
        step.position = position;
        this.steps.add(step);
    }

    protected void cutArea(int position, int hSize, int vSize) {
        SlantArea area = this.areas.get(position);
        this.areas.remove(area);
        Pair<List<SlantLine>, List<SlantArea>> spilt = SlantUtils.cutAreaWith(area, hSize, vSize);
        this.lines.addAll((Collection)spilt.first);
        this.areas.addAll((Collection)spilt.second);
        this.updateLineLimit();
        this.sortAreas();
        PuzzleLayout.Step step = new PuzzleLayout.Step();
        step.type = 2;
        step.position = position;
        step.hSize = hSize;
        step.vSize = vSize;
        this.steps.add(step);
    }

    @Override
    public PuzzleLayout.Info generateInfo() {
        PuzzleLayout.Info info = new PuzzleLayout.Info();
        info.type = 1;
        info.padding = this.padding;
        info.radian = this.radian;
        info.color = this.color;
        info.steps = this.steps;
        ArrayList<PuzzleLayout.LineInfo> lineInfos = new ArrayList<PuzzleLayout.LineInfo>();
        for (Line line : this.lines) {
            PuzzleLayout.LineInfo lineInfo = new PuzzleLayout.LineInfo(line);
            lineInfos.add(lineInfo);
        }
        info.lineInfos = lineInfos;
        return info;
    }
}

