/*
 * Decompiled with CFR 0.152.
 */
package com.xiaopo.flying.puzzle.slant;

import android.graphics.PointF;
import com.xiaopo.flying.puzzle.Line;
import com.xiaopo.flying.puzzle.slant.CrossoverPointF;
import com.xiaopo.flying.puzzle.slant.SlantUtils;

class SlantLine
implements Line {
    CrossoverPointF start;
    CrossoverPointF end;
    private PointF previousStart = new PointF();
    private PointF previousEnd = new PointF();
    public final Line.Direction direction;
    SlantLine attachLineStart;
    SlantLine attachLineEnd;
    Line upperLine;
    Line lowerLine;

    SlantLine(Line.Direction direction) {
        this.direction = direction;
    }

    SlantLine(CrossoverPointF start, CrossoverPointF end, Line.Direction direction) {
        this.start = start;
        this.end = end;
        this.direction = direction;
    }

    @Override
    public float length() {
        return (float)Math.sqrt(Math.pow(this.end.x - this.start.x, 2.0) + Math.pow(this.end.y - this.start.y, 2.0));
    }

    @Override
    public PointF startPoint() {
        return this.start;
    }

    @Override
    public PointF endPoint() {
        return this.end;
    }

    @Override
    public Line lowerLine() {
        return this.lowerLine;
    }

    @Override
    public Line upperLine() {
        return this.upperLine;
    }

    @Override
    public Line attachStartLine() {
        return this.attachLineStart;
    }

    @Override
    public Line attachEndLine() {
        return this.attachLineEnd;
    }

    @Override
    public void setLowerLine(Line lowerLine) {
        this.lowerLine = lowerLine;
    }

    @Override
    public void setUpperLine(Line upperLine) {
        this.upperLine = upperLine;
    }

    @Override
    public Line.Direction direction() {
        return this.direction;
    }

    @Override
    public float slope() {
        return SlantUtils.calculateSlope(this);
    }

    @Override
    public boolean contains(float x, float y, float extra) {
        return SlantUtils.contains(this, x, y, extra);
    }

    @Override
    public boolean move(float offset, float extra) {
        if (this.direction == Line.Direction.HORIZONTAL) {
            if (this.previousStart.y + offset < this.lowerLine.maxY() + extra || this.previousStart.y + offset > this.upperLine.minY() - extra || this.previousEnd.y + offset < this.lowerLine.maxY() + extra || this.previousEnd.y + offset > this.upperLine.minY() - extra) {
                return false;
            }
            this.start.y = this.previousStart.y + offset;
            this.end.y = this.previousEnd.y + offset;
        } else {
            if (this.previousStart.x + offset < this.lowerLine.maxX() + extra || this.previousStart.x + offset > this.upperLine.minX() - extra || this.previousEnd.x + offset < this.lowerLine.maxX() + extra || this.previousEnd.x + offset > this.upperLine.minX() - extra) {
                return false;
            }
            this.start.x = this.previousStart.x + offset;
            this.end.x = this.previousEnd.x + offset;
        }
        return true;
    }

    @Override
    public void prepareMove() {
        this.previousStart.set((PointF)this.start);
        this.previousEnd.set((PointF)this.end);
    }

    @Override
    public void update(float layoutWidth, float layoutHeight) {
        SlantUtils.intersectionOfLines(this.start, this, this.attachLineStart);
        SlantUtils.intersectionOfLines(this.end, this, this.attachLineEnd);
    }

    @Override
    public float minX() {
        return Math.min(this.start.x, this.end.x);
    }

    @Override
    public float maxX() {
        return Math.max(this.start.x, this.end.x);
    }

    @Override
    public float minY() {
        return Math.min(this.start.y, this.end.y);
    }

    @Override
    public float maxY() {
        return Math.max(this.start.y, this.end.y);
    }

    @Override
    public void offset(float x, float y) {
        this.start.offset(x, y);
        this.end.offset(x, y);
    }

    public String toString() {
        return "start --> " + this.start.toString() + ",end --> " + this.end.toString();
    }
}

