/*
 * Decompiled with CFR 0.152.
 */
package com.xiaopo.flying.puzzle;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.xiaopo.flying.puzzle.Border;

public class PuzzlePiece {
    private Drawable mDrawable;
    private Rect mRealBound;
    Matrix mMatrix;
    private Border mBorder;
    private Matrix mDownMatrix;
    private float mTranslateX = 0.0f;
    private float mTranslateY = 0.0f;
    private float mScaleFactor = 0.0f;
    private float mRotation = 0.0f;
    private boolean mNeedHorizontalFlip = false;
    private boolean mNeedVerticalFlip = false;
    private int paddingLeft;
    private int paddingTop;
    private int paddingRight;
    private int paddingBottom;

    private PuzzlePiece(Matrix matrix, Border border) {
        this.mMatrix = matrix;
        this.mBorder = border;
        this.mDownMatrix = new Matrix();
    }

    public PuzzlePiece(Drawable drawable, Border border, Matrix matrix) {
        this(matrix, border);
        this.mDrawable = drawable;
        this.mRealBound = new Rect(0, 0, this.getWidth(), this.getHeight());
    }

    public float getRotation() {
        return this.mRotation;
    }

    void setRotation(float rotation) {
        this.mRotation = rotation;
    }

    public boolean isNeedHorizontalFlip() {
        return this.mNeedHorizontalFlip;
    }

    void setNeedHorizontalFlip(boolean needHorizontalFlip) {
        this.mNeedHorizontalFlip = needHorizontalFlip;
    }

    public boolean isNeedVerticalFlip() {
        return this.mNeedVerticalFlip;
    }

    void setNeedVerticalFlip(boolean needVerticalFlip) {
        this.mNeedVerticalFlip = needVerticalFlip;
    }

    public float getTranslateX() {
        return this.mTranslateX;
    }

    void setTranslateX(float translateX) {
        this.mTranslateX = translateX;
    }

    public float getTranslateY() {
        return this.mTranslateY;
    }

    void setTranslateY(float translateY) {
        this.mTranslateY = translateY;
    }

    public Matrix getMatrix() {
        return this.mMatrix;
    }

    public void setMatrix(Matrix matrix) {
        this.mMatrix = matrix;
    }

    public Matrix getDownMatrix() {
        return this.mDownMatrix;
    }

    public void setDownMatrix(Matrix downMatrix) {
        this.mDownMatrix = downMatrix;
    }

    public float getScaleFactor() {
        return this.mScaleFactor;
    }

    void setScaleFactor(float scaleFactor) {
        this.mScaleFactor = scaleFactor;
    }

    public Border getBorder() {
        return this.mBorder;
    }

    public void setBorder(Border border) {
        this.mBorder = border;
    }

    public void draw(Canvas canvas, Paint paint) {
        this.draw(canvas, paint, 255);
    }

    public void draw(Canvas canvas, Paint paint, int alpha) {
        canvas.save();
        Rect bounds = canvas.getClipBounds();
        bounds.left += this.paddingLeft;
        bounds.top += this.paddingTop;
        bounds.right -= this.paddingRight;
        bounds.bottom -= this.paddingBottom;
        canvas.clipRect(bounds);
        canvas.concat(this.mMatrix);
        this.mDrawable.setBounds(this.mRealBound);
        this.mDrawable.setAlpha(alpha);
        this.mDrawable.draw(canvas);
        canvas.restore();
    }

    public int getWidth() {
        return this.mDrawable.getIntrinsicWidth();
    }

    public int getHeight() {
        return this.mDrawable.getIntrinsicHeight();
    }

    public float[] getBoundPoints() {
        return new float[]{0.0f, 0.0f, this.getWidth(), 0.0f, 0.0f, this.getHeight(), this.getWidth(), this.getHeight()};
    }

    public float[] getMappedBoundPoints() {
        float[] dst = new float[8];
        this.mMatrix.mapPoints(dst, this.getBoundPoints());
        return dst;
    }

    public float[] getMappedPoints(float[] src) {
        float[] dst = new float[src.length];
        this.mMatrix.mapPoints(dst, src);
        return dst;
    }

    public RectF getBound() {
        return new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
    }

    public RectF getMappedBound() {
        RectF dst = new RectF();
        this.mMatrix.mapRect(dst, this.getBound());
        return dst;
    }

    public PointF getCenterPoint() {
        return new PointF((float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
    }

    public PointF getMappedCenterPoint() {
        PointF pointF = this.getCenterPoint();
        float[] dst = this.getMappedPoints(new float[]{pointF.x, pointF.y});
        return new PointF(dst[0], dst[1]);
    }

    public float getMappedWidth() {
        return this.getMappedBound().width();
    }

    public float getMappedHeight() {
        return this.getMappedBound().height();
    }

    public boolean contains(float x, float y) {
        return this.mBorder.getRect().contains(x, y);
    }

    public boolean isFilledBorder() {
        RectF rectF = this.getMappedBound();
        return !(rectF.left > this.mBorder.left() || rectF.top > this.mBorder.top() || rectF.right < this.mBorder.right() || rectF.bottom < this.mBorder.bottom());
    }

    public Drawable getDrawable() {
        return this.mDrawable;
    }

    public void setDrawable(Drawable drawable) {
        this.mDrawable = drawable;
        this.mRealBound = new Rect(0, 0, this.getWidth(), this.getHeight());
    }

    public void setPadding(int padding) {
        this.paddingLeft = padding;
        this.paddingTop = padding;
        this.paddingRight = padding;
        this.paddingBottom = padding;
    }

    public void setPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.paddingLeft = paddingLeft;
        this.paddingTop = paddingTop;
        this.paddingRight = paddingRight;
        this.paddingBottom = paddingBottom;
    }

    public RectF getPaddingBorderRect() {
        RectF rect = this.mBorder.getRect();
        rect.left += (float)this.paddingLeft;
        rect.top += (float)this.paddingTop;
        rect.right -= (float)this.paddingRight;
        rect.bottom -= (float)this.paddingBottom;
        return rect;
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }

    public int getPaddingBottom() {
        return this.paddingBottom;
    }

    public void release() {
        if (this.mMatrix != null) {
            this.mMatrix.reset();
            this.mMatrix = null;
        }
        if (this.mDownMatrix != null) {
            this.mDownMatrix.reset();
            this.mDownMatrix = null;
        }
        if (this.mDrawable != null) {
            this.mDrawable = null;
        }
    }
}

