/*
 * Decompiled with CFR 0.152.
 */
package com.xiaopo.flying.puzzle;

import android.graphics.PointF;
import android.graphics.RectF;
import com.xiaopo.flying.puzzle.Line;
import java.util.Arrays;
import java.util.List;

class Border {
    Line lineLeft;
    Line lineTop;
    Line lineRight;
    Line lineBottom;

    Border(Border src) {
        this.lineLeft = src.lineLeft;
        this.lineTop = src.lineTop;
        this.lineRight = src.lineRight;
        this.lineBottom = src.lineBottom;
    }

    Border(RectF baseRect) {
        this.setBaseRect(baseRect);
    }

    private void setBaseRect(RectF baseRect) {
        float width = baseRect.width();
        float height = baseRect.height();
        PointF one = new PointF(baseRect.left, baseRect.top);
        PointF two = new PointF(baseRect.right, baseRect.top);
        PointF three = new PointF(baseRect.left, baseRect.bottom);
        PointF four = new PointF(baseRect.right, baseRect.bottom);
        this.lineLeft = new Line(one, three);
        this.lineTop = new Line(one, two);
        this.lineRight = new Line(two, four);
        this.lineBottom = new Line(three, four);
    }

    float width() {
        return this.lineRight.start.x - this.lineLeft.start.x;
    }

    float height() {
        return this.lineBottom.start.y - this.lineTop.start.y;
    }

    float left() {
        return this.lineLeft.start.x;
    }

    float top() {
        return this.lineTop.start.y;
    }

    float right() {
        return this.lineRight.start.x;
    }

    float bottom() {
        return this.lineBottom.start.y;
    }

    float centerX() {
        return (this.right() + this.left()) * 0.5f;
    }

    float centerY() {
        return (this.bottom() + this.top()) * 0.5f;
    }

    List<Line> getLines() {
        return Arrays.asList(this.lineLeft, this.lineTop, this.lineRight, this.lineBottom);
    }

    RectF getRect() {
        return new RectF(this.left(), this.top(), this.right(), this.bottom());
    }

    boolean contains(Line line) {
        return this.lineLeft == line || this.lineTop == line || this.lineRight == line || this.lineBottom == line;
    }

    public String toString() {
        return "left line:\n" + this.lineLeft.toString() + "\ntop line:\n" + this.lineTop.toString() + "\nright line:\n" + this.lineRight.toString() + "\nbottom line:\n" + this.lineBottom.toString() + "\nthe rect is \n" + this.getRect().toString();
    }
}

