/*
 * Decompiled with CFR 0.152.
 */
package com.xiaopo.flying.puzzle;

import android.graphics.PointF;
import android.graphics.RectF;
import android.util.Log;

public class Line {
    final PointF start;
    final PointF end;
    private Direction direction = Direction.HORIZONTAL;
    private Line attachLineStart;
    private Line attachLineEnd;
    private Line mUpperLine;
    private Line mLowerLine;
    private final RectF mBound = new RectF();

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The line is ").append(this.direction.name()).append(",start point is ").append(this.start).append(",end point is ").append(this.end).append(",length is ").append(this.length()).append("\n");
        if (this.attachLineStart != null) {
            stringBuilder.append("\n").append("attachLineStart is ").append(this.attachLineStart.toString());
        }
        if (this.attachLineEnd != null) {
            stringBuilder.append("\n").append("attachLineEnd is ").append(this.attachLineEnd.toString());
        }
        return stringBuilder.append("\n").toString();
    }

    public Line(PointF start, PointF end) {
        this.start = start;
        this.end = end;
        if (start.x == end.x) {
            this.direction = Direction.VERTICAL;
        } else if (start.y == end.y) {
            this.direction = Direction.HORIZONTAL;
        } else {
            Log.d((String)"Line", (String)"Line: current only support two direction");
        }
    }

    public float length() {
        return (float)Math.sqrt(Math.pow(this.end.x - this.start.x, 2.0) + Math.pow(this.end.y - this.start.y, 2.0));
    }

    public PointF centerPoint() {
        return new PointF((this.end.x - this.start.x) / 2.0f, (this.end.y - this.start.y) / 2.0f);
    }

    public float getPosition() {
        if (this.direction == Direction.HORIZONTAL) {
            return this.start.y;
        }
        return this.start.x;
    }

    public boolean contains(float x, float y, float extra) {
        if (this.direction == Direction.HORIZONTAL) {
            this.mBound.left = this.start.x;
            this.mBound.right = this.end.x;
            this.mBound.top = this.start.y - extra / 2.0f;
            this.mBound.bottom = this.start.y + extra / 2.0f;
        } else if (this.direction == Direction.VERTICAL) {
            this.mBound.top = this.start.y;
            this.mBound.bottom = this.end.y;
            this.mBound.left = this.start.x - extra / 2.0f;
            this.mBound.right = this.start.x + extra / 2.0f;
        }
        return this.mBound.contains(x, y);
    }

    public RectF getCenterBound(float position, float length, float borderStrokeWidth, boolean isStartLine) {
        if (this.direction == Direction.HORIZONTAL) {
            this.mBound.left = position - length / 4.0f;
            this.mBound.right = position + length / 4.0f;
            if (isStartLine) {
                this.mBound.top = this.start.y - borderStrokeWidth * 1.5f + borderStrokeWidth / 2.0f;
                this.mBound.bottom = this.start.y + borderStrokeWidth * 1.5f + borderStrokeWidth / 2.0f;
            } else {
                this.mBound.top = this.start.y - borderStrokeWidth * 1.5f - borderStrokeWidth / 2.0f;
                this.mBound.bottom = this.start.y + borderStrokeWidth * 1.5f - borderStrokeWidth / 2.0f;
            }
        } else if (this.direction == Direction.VERTICAL) {
            this.mBound.top = position - length / 4.0f;
            this.mBound.bottom = position + length / 4.0f;
            if (isStartLine) {
                this.mBound.left = this.start.x - borderStrokeWidth * 1.5f + borderStrokeWidth / 2.0f;
                this.mBound.right = this.start.x + borderStrokeWidth * 1.5f + borderStrokeWidth / 2.0f;
            } else {
                this.mBound.left = this.start.x - borderStrokeWidth * 1.5f - borderStrokeWidth / 2.0f;
                this.mBound.right = this.start.x + borderStrokeWidth * 1.5f - borderStrokeWidth / 2.0f;
            }
        }
        return this.mBound;
    }

    public void update() {
        if (this.direction == Direction.HORIZONTAL) {
            if (this.attachLineStart != null) {
                this.start.x = this.attachLineStart.getPosition();
            }
            if (this.attachLineEnd != null) {
                this.end.x = this.attachLineEnd.getPosition();
            }
        } else if (this.direction == Direction.VERTICAL) {
            if (this.attachLineStart != null) {
                this.start.y = this.attachLineStart.getPosition();
            }
            if (this.attachLineEnd != null) {
                this.end.y = this.attachLineEnd.getPosition();
            }
        }
    }

    public void moveTo(float position, float extra) {
        if (this.direction == Direction.HORIZONTAL) {
            if (position < this.mLowerLine.start.y + extra || position > this.mUpperLine.start.y - extra) {
                return;
            }
            this.start.y = position;
            this.end.y = position;
        } else if (this.direction == Direction.VERTICAL) {
            if (position < this.mLowerLine.start.x + extra || position > this.mUpperLine.start.x - extra) {
                return;
            }
            this.start.x = position;
            this.end.x = position;
        }
    }

    public Line getAttachLineStart() {
        return this.attachLineStart;
    }

    public void setAttachLineStart(Line attachLineStart) {
        this.attachLineStart = attachLineStart;
    }

    public Line getAttachLineEnd() {
        return this.attachLineEnd;
    }

    public void setAttachLineEnd(Line attachLineEnd) {
        this.attachLineEnd = attachLineEnd;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Line getUpperLine() {
        return this.mUpperLine;
    }

    public void setUpperLine(Line upperLine) {
        this.mUpperLine = upperLine;
    }

    public Line getLowerLine() {
        return this.mLowerLine;
    }

    public void setLowerLine(Line lowerLine) {
        this.mLowerLine = lowerLine;
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

