/*
 * Decompiled with CFR 0.152.
 */
package com.xiaopo.flying.puzzle;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.provider.MediaStore;
import android.support.annotation.ColorInt;
import android.support.v4.view.MotionEventCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.xiaopo.flying.puzzle.Border;
import com.xiaopo.flying.puzzle.BorderUtil;
import com.xiaopo.flying.puzzle.Line;
import com.xiaopo.flying.puzzle.PuzzleLayout;
import com.xiaopo.flying.puzzle.PuzzlePiece;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class PuzzleView
extends View {
    private static final String TAG = "PuzzleView";
    private Mode mCurrentMode = Mode.NONE;
    private Paint mBitmapPaint;
    private Paint mBorderPaint;
    private Paint mSelectedBorderPaint;
    private RectF mBorderRect;
    private RectF mSelectedRect;
    private PuzzleLayout mPuzzleLayout;
    private float mBorderWidth = 4.0f;
    private float mExtraSize = 100.0f;
    private float mDownX;
    private float mDownY;
    private float mOldDistance;
    private PointF mMidPoint;
    private List<PuzzlePiece> mPuzzlePieces = new ArrayList<PuzzlePiece>();
    private Line mHandlingLine;
    private PuzzlePiece mHandlingPiece;
    private PuzzlePiece mPreviewHandlingPiece;
    private PuzzlePiece mReplacePiece;
    private List<PuzzlePiece> mChangedPieces = new ArrayList<PuzzlePiece>();
    private boolean mNeedDrawBorder = false;
    private boolean mMoveLineEnable = true;
    private boolean mNeedDrawOuterBorder = false;
    private Handler mHandler;

    public PuzzleView(Context context) {
        this(context, null, 0);
    }

    public PuzzleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PuzzleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mBorderRect = new RectF();
        this.mSelectedRect = new RectF();
        this.mBitmapPaint = new Paint();
        this.mBitmapPaint.setAntiAlias(true);
        this.mBitmapPaint.setFilterBitmap(true);
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setColor(-1);
        this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
        this.mSelectedBorderPaint = new Paint();
        this.mSelectedBorderPaint.setAntiAlias(true);
        this.mSelectedBorderPaint.setStyle(Paint.Style.STROKE);
        this.mSelectedBorderPaint.setColor(Color.parseColor((String)"#99BBFB"));
        this.mSelectedBorderPaint.setStrokeWidth(this.mBorderWidth);
        this.mHandler = new Handler();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mPuzzleLayout == null || this.mPuzzleLayout.getBorderSize() == 0) {
            Log.e((String)TAG, (String)"the puzzle layout or its border can not be null");
            return;
        }
        for (int i = 0; i < this.mPuzzleLayout.getBorderSize(); ++i) {
            Border border = this.mPuzzleLayout.getBorder(i);
            if (i >= this.mPuzzlePieces.size()) break;
            PuzzlePiece piece = this.mPuzzlePieces.get(i);
            canvas.save();
            canvas.clipRect(border.getRect());
            if (this.mPuzzlePieces.size() > i) {
                piece.draw(canvas, this.mBitmapPaint);
            }
            canvas.restore();
        }
        if (this.mNeedDrawBorder) {
            for (Line line : this.mPuzzleLayout.getLines()) {
                this.drawLine(canvas, line);
            }
        }
        if (this.mNeedDrawOuterBorder) {
            for (Line line : this.mPuzzleLayout.getOuterLines()) {
                this.drawLine(canvas, line);
            }
        }
        if (this.mHandlingPiece != null && this.mCurrentMode != Mode.SWAP) {
            this.drawSelectedBorder(canvas, this.mHandlingPiece);
        }
        if (this.mHandlingPiece != null && this.mCurrentMode == Mode.SWAP) {
            this.mHandlingPiece.draw(canvas, this.mBitmapPaint, 128);
            if (this.mReplacePiece != null) {
                this.drawSelectedBorder(canvas, this.mReplacePiece);
            }
        }
    }

    private void drawSelectedBorder(Canvas canvas, PuzzlePiece piece) {
        this.mSelectedRect.set(piece.getBorder().getRect());
        this.mSelectedRect.left += this.mBorderWidth / 2.0f;
        this.mSelectedRect.top += this.mBorderWidth / 2.0f;
        this.mSelectedRect.right -= this.mBorderWidth / 2.0f;
        this.mSelectedRect.bottom -= this.mBorderWidth / 2.0f;
        canvas.drawRect(this.mSelectedRect, this.mSelectedBorderPaint);
        this.mSelectedBorderPaint.setStyle(Paint.Style.FILL);
        for (Line line : piece.getBorder().getLines()) {
            if (!this.mPuzzleLayout.getLines().contains(line)) continue;
            if (line.getDirection() == Line.Direction.HORIZONTAL) {
                canvas.drawRoundRect(line.getCenterBound(this.mSelectedRect.centerX(), this.mSelectedRect.width(), this.mBorderWidth, line == piece.getBorder().lineTop), this.mBorderWidth * 2.0f, this.mBorderWidth * 2.0f, this.mSelectedBorderPaint);
                continue;
            }
            if (line.getDirection() != Line.Direction.VERTICAL) continue;
            canvas.drawRoundRect(line.getCenterBound(this.mSelectedRect.centerY(), this.mSelectedRect.height(), this.mBorderWidth, line == piece.getBorder().lineLeft), this.mBorderWidth * 2.0f, this.mBorderWidth * 2.0f, this.mSelectedBorderPaint);
        }
        this.mSelectedBorderPaint.setStyle(Paint.Style.STROKE);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mMoveLineEnable) {
            return super.onTouchEvent(event);
        }
        switch (MotionEventCompat.getActionMasked((MotionEvent)event)) {
            case 0: {
                this.mDownX = event.getX();
                this.mDownY = event.getY();
                this.mHandlingLine = this.findHandlingLine();
                if (this.mHandlingLine != null) {
                    this.mCurrentMode = Mode.MOVE;
                    this.mChangedPieces.clear();
                    this.mChangedPieces.addAll(this.findChangedPiece());
                    for (int i = 0; i < this.mChangedPieces.size(); ++i) {
                        this.mChangedPieces.get(i).getDownMatrix().set(this.mChangedPieces.get(i).getMatrix());
                    }
                    break;
                }
                this.mHandlingPiece = this.findHandlingPiece();
                if (this.mHandlingPiece == null) break;
                this.mCurrentMode = Mode.DRAG;
                this.mHandlingPiece.getDownMatrix().set(this.mHandlingPiece.getMatrix());
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        PuzzleView.this.mCurrentMode = Mode.SWAP;
                        PuzzleView.this.invalidate();
                        Log.d((String)PuzzleView.TAG, (String)"run: long pressed");
                    }
                }, 1000L);
                break;
            }
            case 5: {
                this.mOldDistance = this.calculateDistance(event);
                this.mMidPoint = this.calculateMidPoint(event);
                if (this.mHandlingPiece == null || !this.isInPhotoArea(this.mHandlingPiece, event.getX(1), event.getY(1)) || this.mCurrentMode == Mode.MOVE) break;
                this.mCurrentMode = Mode.ZOOM;
                break;
            }
            case 2: {
                switch (this.mCurrentMode) {
                    case NONE: {
                        break;
                    }
                    case DRAG: {
                        this.dragPiece(this.mHandlingPiece, event);
                        break;
                    }
                    case ZOOM: {
                        this.zoomPiece(this.mHandlingPiece, event);
                        break;
                    }
                    case MOVE: {
                        this.moveLine(event);
                        this.mPuzzleLayout.update();
                        this.updatePieceInBorder(event);
                        break;
                    }
                    case SWAP: {
                        this.mReplacePiece = this.findReplacePiece(event);
                        this.dragPiece(this.mHandlingPiece, event);
                        Log.d((String)TAG, (String)"onTouchEvent: replace");
                    }
                }
                if ((Math.abs(event.getX() - this.mDownX) > 10.0f || Math.abs(event.getY() - this.mDownY) > 10.0f) && this.mCurrentMode != Mode.SWAP) {
                    this.mHandler.removeCallbacksAndMessages(null);
                }
                this.invalidate();
                break;
            }
            case 1: {
                this.mHandlingLine = null;
                switch (this.mCurrentMode) {
                    case DRAG: {
                        if (!this.mHandlingPiece.isFilledBorder()) {
                            this.moveToFillBorder(this.mHandlingPiece);
                        }
                        if (this.mPreviewHandlingPiece == this.mHandlingPiece && Math.abs(this.mDownX - event.getX()) < 3.0f && Math.abs(this.mDownY - event.getY()) < 3.0f) {
                            this.mHandlingPiece = null;
                        }
                        this.mPreviewHandlingPiece = this.mHandlingPiece;
                        break;
                    }
                    case ZOOM: {
                        if (this.mHandlingPiece.isFilledBorder()) break;
                        this.fillBorder(this.mHandlingPiece);
                        this.mHandlingPiece.setScaleFactor(0.0f);
                        break;
                    }
                    case SWAP: {
                        if (this.mHandlingPiece != null && this.mReplacePiece != null) {
                            Drawable temp = this.mHandlingPiece.getDrawable();
                            this.mHandlingPiece.setDrawable(this.mReplacePiece.getDrawable());
                            this.mReplacePiece.setDrawable(temp);
                            this.fillBorder(this.mHandlingPiece);
                            this.fillBorder(this.mReplacePiece);
                        }
                        this.mHandlingPiece = null;
                        this.mReplacePiece = null;
                    }
                }
                this.mCurrentMode = Mode.NONE;
                this.mHandler.removeCallbacksAndMessages(null);
                this.invalidate();
                break;
            }
        }
        return true;
    }

    private void zoomPiece(PuzzlePiece piece, MotionEvent event) {
        if (piece != null && event.getPointerCount() >= 2) {
            float newDistance = this.calculateDistance(event);
            piece.getMatrix().set(piece.getDownMatrix());
            piece.getMatrix().postScale(newDistance / this.mOldDistance, newDistance / this.mOldDistance, this.mMidPoint.x, this.mMidPoint.y);
            piece.setScaleFactor(piece.getMappedWidth() / (float)piece.getWidth());
        }
    }

    private void dragPiece(PuzzlePiece piece, MotionEvent event) {
        if (piece != null) {
            piece.getMatrix().set(piece.getDownMatrix());
            piece.getMatrix().postTranslate(event.getX() - this.mDownX, event.getY() - this.mDownY);
            piece.setTranslateX(piece.getMappedCenterPoint().x - piece.getBorder().centerX());
            piece.setTranslateY(piece.getMappedCenterPoint().y - piece.getBorder().centerY());
        }
    }

    private void moveToFillBorder(PuzzlePiece piece) {
        Border border = piece.getBorder();
        RectF rectF = piece.getMappedBound();
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        if (rectF.left > border.left()) {
            offsetX = border.left() - rectF.left;
        }
        if (rectF.top > border.top()) {
            offsetY = border.top() - rectF.top;
        }
        if (rectF.right < border.right()) {
            offsetX = border.right() - rectF.right;
        }
        if (rectF.bottom < border.bottom()) {
            offsetY = border.bottom() - rectF.bottom;
        }
        piece.getMatrix().postTranslate(offsetX, offsetY);
        piece.setTranslateX(border.centerX() - piece.getMappedCenterPoint().x);
        piece.setTranslateY(border.centerY() - piece.getMappedCenterPoint().y);
        if (!piece.isFilledBorder()) {
            this.fillBorder(piece);
        }
    }

    private void fillBorder(PuzzlePiece piece) {
        piece.getMatrix().reset();
        RectF rectF = piece.getBorder().getRect();
        float offsetX = rectF.centerX() - (float)(piece.getWidth() / 2);
        float offsetY = rectF.centerY() - (float)(piece.getHeight() / 2);
        piece.getMatrix().postTranslate(offsetX, offsetY);
        float scale = this.calculateFillScaleFactor(piece);
        piece.getMatrix().postScale(scale, scale, rectF.centerX(), rectF.centerY());
        if (piece.getRotation() != 0.0f) {
            this.rotate(piece, piece.getRotation(), false);
        }
        if (piece.isNeedHorizontalFlip()) {
            this.flipHorizontally(piece, false);
        }
        if (piece.isNeedVerticalFlip()) {
            this.flipVertically(piece, false);
        }
        piece.setTranslateX(0.0f);
        piece.setTranslateY(0.0f);
        piece.setScaleFactor(0.0f);
    }

    private float calculateFillScaleFactor(PuzzlePiece piece) {
        RectF rectF = piece.getBorder().getRect();
        float scale = piece.getRotation() == 90.0f || piece.getRotation() == 270.0f ? ((float)piece.getHeight() * rectF.height() > rectF.width() * (float)piece.getWidth() ? (rectF.height() + this.mExtraSize) / (float)piece.getWidth() : (rectF.width() + this.mExtraSize) / (float)piece.getHeight()) : ((float)piece.getWidth() * rectF.height() > rectF.width() * (float)piece.getHeight() ? (rectF.height() + this.mExtraSize) / (float)piece.getHeight() : (rectF.width() + this.mExtraSize) / (float)piece.getWidth());
        return scale;
    }

    private float calculateFillScaleFactor(PuzzlePiece piece, Border border) {
        RectF rectF = border.getRect();
        float scale = (float)piece.getWidth() * rectF.height() > rectF.width() * (float)piece.getHeight() ? rectF.height() / (float)piece.getHeight() : rectF.width() / (float)piece.getWidth();
        return scale;
    }

    private void updatePieceInBorder(MotionEvent event) {
        for (PuzzlePiece piece : this.mChangedPieces) {
            float scale = this.calculateFillScaleFactor(piece, this.mPuzzleLayout.getOuterBorder());
            if (piece.getScaleFactor() > scale && piece.isFilledBorder()) {
                piece.getMatrix().set(piece.getDownMatrix());
                if (this.mHandlingLine.getDirection() == Line.Direction.HORIZONTAL) {
                    piece.getMatrix().postTranslate(0.0f, (event.getY() - this.mDownY) / 2.0f);
                    continue;
                }
                if (this.mHandlingLine.getDirection() != Line.Direction.VERTICAL) continue;
                piece.getMatrix().postTranslate((event.getX() - this.mDownX) / 2.0f, 0.0f);
                continue;
            }
            if (piece.isFilledBorder() && (piece.getTranslateX() != 0.0f || piece.getTranslateY() != 0.0f)) {
                piece.getMatrix().set(piece.getDownMatrix());
                if (this.mHandlingLine.getDirection() == Line.Direction.HORIZONTAL) {
                    piece.getMatrix().postTranslate(0.0f, (event.getY() - this.mDownY) / 2.0f);
                    continue;
                }
                if (this.mHandlingLine.getDirection() != Line.Direction.VERTICAL) continue;
                piece.getMatrix().postTranslate((event.getX() - this.mDownX) / 2.0f, 0.0f);
                continue;
            }
            this.fillBorder(piece);
        }
    }

    private void moveLine(MotionEvent event) {
        if (this.mHandlingLine == null) {
            return;
        }
        if (this.mHandlingLine.getDirection() == Line.Direction.HORIZONTAL) {
            this.mHandlingLine.moveTo(event.getY(), 40.0f);
        } else if (this.mHandlingLine.getDirection() == Line.Direction.VERTICAL) {
            this.mHandlingLine.moveTo(event.getX(), 40.0f);
        }
    }

    private List<PuzzlePiece> findChangedPiece() {
        if (this.mHandlingLine == null) {
            return new ArrayList<PuzzlePiece>();
        }
        ArrayList<PuzzlePiece> puzzlePieces = new ArrayList<PuzzlePiece>();
        for (PuzzlePiece piece : this.mPuzzlePieces) {
            if (!piece.getBorder().contains(this.mHandlingLine)) continue;
            puzzlePieces.add(piece);
        }
        return puzzlePieces;
    }

    private Line findHandlingLine() {
        for (Line line : this.mPuzzleLayout.getLines()) {
            if (!line.contains(this.mDownX, this.mDownY, 20.0f)) continue;
            return line;
        }
        return null;
    }

    private PuzzlePiece findHandlingPiece() {
        for (PuzzlePiece piece : this.mPuzzlePieces) {
            if (!piece.contains(this.mDownX, this.mDownY)) continue;
            return piece;
        }
        return null;
    }

    private PuzzlePiece findReplacePiece(MotionEvent event) {
        for (PuzzlePiece piece : this.mPuzzlePieces) {
            if (!piece.contains(event.getX(), event.getY()) || piece == this.mHandlingPiece) continue;
            return piece;
        }
        return null;
    }

    private boolean isInPhotoArea(PuzzlePiece handlingPhoto, float x, float y) {
        return handlingPhoto.contains(x, y);
    }

    private float calculateDistance(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    private PointF calculateMidPoint(MotionEvent event) {
        float x = (event.getX(0) + event.getX(1)) / 2.0f;
        float y = (event.getY(0) + event.getY(1)) / 2.0f;
        return new PointF(x, y);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mBorderRect.left = this.getPaddingLeft();
        this.mBorderRect.top = this.getPaddingTop();
        this.mBorderRect.right = w - this.getPaddingRight();
        this.mBorderRect.bottom = h - this.getPaddingBottom();
        if (this.mPuzzleLayout != null) {
            this.mPuzzleLayout.setOuterBorder(this.mBorderRect);
            this.mPuzzleLayout.layout();
        }
        if (this.mPuzzlePieces.size() != 0) {
            for (int i = 0; i < this.mPuzzlePieces.size(); ++i) {
                PuzzlePiece piece = this.mPuzzlePieces.get(i);
                piece.setBorder(this.mPuzzleLayout.getBorder(i));
                piece.getMatrix().set(BorderUtil.createMatrix(this.mPuzzleLayout.getBorder(i), piece.getWidth(), piece.getHeight(), this.mExtraSize));
            }
        }
        this.invalidate();
    }

    public void replace(Bitmap bitmap) {
        this.replace((Drawable)new BitmapDrawable(this.getResources(), bitmap));
    }

    public void replace(Drawable bitmapDrawable) {
        if (this.mHandlingPiece == null) {
            return;
        }
        this.mHandlingPiece.setDrawable(bitmapDrawable);
        this.fillBorder(this.mHandlingPiece);
        this.invalidate();
    }

    public void flipHorizontally() {
        this.flipHorizontally(this.mHandlingPiece, true);
    }

    public void flipVertically() {
        this.flipVertically(this.mHandlingPiece, true);
    }

    private void flipHorizontally(PuzzlePiece piece, boolean needChangeStatus) {
        if (piece == null) {
            return;
        }
        if (needChangeStatus) {
            piece.setNeedHorizontalFlip(!piece.isNeedHorizontalFlip());
        }
        piece.getMatrix().postScale(-1.0f, 1.0f, piece.getMappedCenterPoint().x, piece.getMappedCenterPoint().y);
        this.invalidate();
    }

    private void flipVertically(PuzzlePiece piece, boolean needChangeStatus) {
        if (piece == null) {
            return;
        }
        if (needChangeStatus) {
            piece.setNeedVerticalFlip(!piece.isNeedVerticalFlip());
        }
        piece.getMatrix().postScale(1.0f, -1.0f, piece.getMappedCenterPoint().x, piece.getMappedCenterPoint().y);
        this.invalidate();
    }

    public void rotate(float rotate) {
        this.rotate(this.mHandlingPiece, rotate, true);
    }

    private void rotate(PuzzlePiece piece, float rotate, boolean needChangeStatus) {
        if (piece == null) {
            return;
        }
        if (needChangeStatus) {
            piece.setRotation((piece.getRotation() + rotate) % 360.0f);
        }
        if (needChangeStatus) {
            piece.getMatrix().postRotate(rotate, piece.getMappedCenterPoint().x, piece.getMappedCenterPoint().y);
            this.fillBorder(piece);
        } else {
            piece.getMatrix().postRotate(piece.getRotation(), piece.getMappedCenterPoint().x, piece.getMappedCenterPoint().y);
        }
        this.invalidate();
    }

    public void addPiece(Bitmap bitmap) {
        this.addPiece((Drawable)new BitmapDrawable(this.getResources(), bitmap));
    }

    public void addPieces(List<Bitmap> bitmaps) {
        for (Bitmap bitmap : bitmaps) {
            this.addPiece(bitmap);
        }
        this.invalidate();
    }

    public void addPiece(Drawable drawable) {
        int index = this.mPuzzlePieces.size();
        if (index >= this.mPuzzleLayout.getBorderSize()) {
            Log.e((String)TAG, (String)("addPiece: can not add more. the current puzzle layout can contains " + this.mPuzzleLayout.getBorderSize() + " puzzle piece."));
            return;
        }
        Matrix matrix = BorderUtil.createMatrix(this.mPuzzleLayout.getBorder(index), drawable, this.mExtraSize);
        PuzzlePiece layoutPhoto = new PuzzlePiece(drawable, this.mPuzzleLayout.getBorder(index), matrix);
        this.mPuzzlePieces.add(layoutPhoto);
        this.invalidate();
    }

    private void drawLine(Canvas canvas, Line line) {
        canvas.drawLine(line.start.x, line.start.y, line.end.x, line.end.y, this.mBorderPaint);
    }

    public void reset() {
        this.mHandlingLine = null;
        this.mHandlingPiece = null;
        if (this.mPuzzleLayout != null) {
            this.mPuzzleLayout.reset();
        }
        this.mPuzzlePieces.clear();
        this.mChangedPieces.clear();
        this.invalidate();
    }

    public PuzzleLayout getPuzzleLayout() {
        return this.mPuzzleLayout;
    }

    public void setPuzzleLayout(PuzzleLayout puzzleLayout) {
        this.reset();
        this.mPuzzleLayout = puzzleLayout;
        this.mPuzzleLayout.setOuterBorder(this.mBorderRect);
        this.mPuzzleLayout.layout();
        this.invalidate();
    }

    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBorderWidth(float borderWidth) {
        this.mBorderWidth = borderWidth;
        this.mBorderPaint.setStrokeWidth(borderWidth);
        this.invalidate();
    }

    public boolean isNeedDrawBorder() {
        return this.mNeedDrawBorder;
    }

    public void setNeedDrawBorder(boolean needDrawBorder) {
        this.mNeedDrawBorder = needDrawBorder;
        this.mHandlingPiece = null;
        this.mPreviewHandlingPiece = null;
        this.invalidate();
    }

    public boolean isMoveLineEnable() {
        return this.mMoveLineEnable;
    }

    public void setMoveLineEnable(boolean moveLineEnable) {
        this.mMoveLineEnable = moveLineEnable;
    }

    public float getExtraSize() {
        return this.mExtraSize;
    }

    public void setExtraSize(float extraSize) {
        if (extraSize < 0.0f) {
            Log.e((String)TAG, (String)"setExtraSize: the extra size must be greater than 0");
            this.mExtraSize = 0.0f;
        } else {
            this.mExtraSize = extraSize;
        }
    }

    public boolean isNeedDrawOuterBorder() {
        return this.mNeedDrawOuterBorder;
    }

    public void setNeedDrawOuterBorder(boolean needDrawOuterBorder) {
        this.mNeedDrawOuterBorder = needDrawOuterBorder;
    }

    public void setBorderColor(@ColorInt int color) {
        this.mBorderPaint.setColor(color);
        this.invalidate();
    }

    public void setSelectedBorderColor(@ColorInt int color) {
        this.mSelectedBorderPaint.setColor(color);
        this.invalidate();
    }

    public Bitmap createBitmap() {
        this.mHandlingPiece = null;
        this.invalidate();
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        this.draw(canvas);
        return bitmap;
    }

    public void save(File file) {
        this.save(file, 100, null);
    }

    public void save(File file, Callback callback) {
        this.save(file, 100, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file, int quality, Callback callback) {
        Bitmap bitmap = null;
        FileOutputStream outputStream = null;
        try {
            bitmap = this.createBitmap();
            outputStream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)outputStream);
            if (!file.exists()) {
                Log.e((String)TAG, (String)"notifySystemGallery: the file do not exist.");
                return;
            }
            try {
                MediaStore.Images.Media.insertImage((ContentResolver)this.getContext().getContentResolver(), (String)file.getAbsolutePath(), (String)file.getName(), null);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.getContext().sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)file)));
            if (callback != null) {
                callback.onSuccess();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            if (callback != null) {
                callback.onFailed();
            }
        }
        finally {
            if (bitmap != null) {
                bitmap.recycle();
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static interface OnPieceSelectedListener {
        public void onPieceSelected(PuzzlePiece var1);
    }

    public static interface Callback {
        public void onSuccess();

        public void onFailed();
    }

    private static enum Mode {
        NONE,
        DRAG,
        ZOOM,
        MOVE,
        SWAP;

    }
}

