/*
 * Decompiled with CFR 0.152.
 */
package com.xiaopo.flying.puzzle;

import android.graphics.PointF;
import android.graphics.RectF;
import com.xiaopo.flying.puzzle.Border;
import com.xiaopo.flying.puzzle.BorderComparator;
import com.xiaopo.flying.puzzle.BorderUtil;
import com.xiaopo.flying.puzzle.Line;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class PuzzleLayout {
    protected static final String TAG = "PuzzleLayout";
    protected int mTheme;
    private Border mOuterBorder;
    private List<Border> mBorders = new ArrayList<Border>();
    private List<Line> mLines = new ArrayList<Line>();
    private List<Line> mOuterLines = new ArrayList<Line>(4);
    private Comparator<Border> mBorderComparator = new BorderComparator();

    public PuzzleLayout() {
    }

    public PuzzleLayout(RectF baseRect) {
        this.setOuterBorder(baseRect);
    }

    public void setOuterBorder(RectF baseRect) {
        float width = baseRect.width();
        float height = baseRect.height();
        PointF one = new PointF(0.0f, 0.0f);
        PointF two = new PointF(width, 0.0f);
        PointF three = new PointF(0.0f, height);
        PointF four = new PointF(width, height);
        Line lineLeft = new Line(one, three);
        Line lineTop = new Line(one, two);
        Line lineRight = new Line(two, four);
        Line lineBottom = new Line(three, four);
        this.mOuterLines.clear();
        this.mOuterLines.add(lineLeft);
        this.mOuterLines.add(lineTop);
        this.mOuterLines.add(lineRight);
        this.mOuterLines.add(lineBottom);
        this.mOuterBorder = new Border(baseRect);
        this.mBorders.clear();
        this.mBorders.add(this.mOuterBorder);
    }

    public abstract void layout();

    public List<Border> addLine(Border border, Line.Direction direction, float ratio) {
        this.mBorders.remove(border);
        Line line = BorderUtil.createLine(border, direction, ratio);
        this.mLines.add(line);
        List<Border> borders = BorderUtil.cutBorder(border, line);
        this.mBorders.addAll(borders);
        this.updateLineLimit();
        Collections.sort(this.mBorders, this.mBorderComparator);
        return borders;
    }

    public void cutBorderEqualPart(Border border, int part, Line.Direction direction) {
        Border temp = border;
        for (int i = part; i > 1; --i) {
            temp = this.addLine(temp, direction, (float)(i - 1) / (float)i).get(0);
        }
    }

    public List<Border> addCross(Border border, float radio) {
        return this.addCross(border, radio, radio);
    }

    public List<Border> addCross(Border border, float horizontalRadio, float verticalRadio) {
        this.mBorders.remove(border);
        Line horizontal = BorderUtil.createLine(border, Line.Direction.HORIZONTAL, horizontalRadio);
        Line vertical = BorderUtil.createLine(border, Line.Direction.VERTICAL, verticalRadio);
        this.mLines.add(horizontal);
        this.mLines.add(vertical);
        List<Border> borders = BorderUtil.cutBorderCross(border, horizontal, vertical);
        this.mBorders.addAll(borders);
        this.updateLineLimit();
        if (this.mBorderComparator == null) {
            this.mBorderComparator = new BorderComparator();
        }
        Collections.sort(this.mBorders, this.mBorderComparator);
        return borders;
    }

    private void updateLineLimit() {
        for (Line line : this.mLines) {
            this.updateUpperLine(line);
            this.updateLowerLine(line);
        }
    }

    private void updateLowerLine(Line line) {
        for (Line l : this.mLines) {
            if (!(l.getPosition() > line.getLowerLine().getPosition()) || !(l.getPosition() < line.getPosition()) || l.getDirection() != line.getDirection() || l.getDirection() == Line.Direction.HORIZONTAL && (l.end.x <= line.start.x || l.start.x >= line.end.x) || l.getDirection() == Line.Direction.VERTICAL && (l.end.y <= line.start.y || l.start.y >= line.end.y)) continue;
            line.setLowerLine(l);
        }
    }

    private void updateUpperLine(Line line) {
        for (Line l : this.mLines) {
            if (!(l.getPosition() < line.getUpperLine().getPosition()) || !(l.getPosition() > line.getPosition()) || l.getDirection() != line.getDirection() || l.getDirection() == Line.Direction.HORIZONTAL && (l.end.x <= line.start.x || l.start.x >= line.end.x) || l.getDirection() == Line.Direction.VERTICAL && (l.end.y <= line.start.y || l.start.y >= line.end.y)) continue;
            line.setUpperLine(l);
        }
    }

    public void reset() {
        this.mLines.clear();
        this.mBorders.clear();
        this.mBorders.add(this.mOuterBorder);
    }

    public void update() {
        for (Line line : this.mLines) {
            line.update();
        }
    }

    public int getBorderSize() {
        return this.mBorders.size();
    }

    public Border getBorder(int index) {
        return this.mBorders.get(index);
    }

    public List<Line> getLines() {
        return this.mLines;
    }

    public List<Border> getBorders() {
        return this.mBorders;
    }

    public Border getOuterBorder() {
        return this.mOuterBorder;
    }

    public List<Line> getOuterLines() {
        return this.mOuterLines;
    }

    public int getTheme() {
        return this.mTheme;
    }
}

