/*
 * Decompiled with CFR 0.152.
 */
package com.xiaopo.flying.puzzle;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.xiaopo.flying.puzzle.Border;
import com.xiaopo.flying.puzzle.Line;
import java.util.ArrayList;
import java.util.List;

class BorderUtil {
    private static final String TAG = "BorderUtil";

    BorderUtil() {
    }

    static Line createLine(Border border, Line.Direction direction, float ratio) {
        PointF one = new PointF();
        PointF two = new PointF();
        if (direction == Line.Direction.HORIZONTAL) {
            one.x = border.left();
            one.y = border.height() * ratio + border.top();
            two.x = border.right();
            two.y = border.height() * ratio + border.top();
        } else if (direction == Line.Direction.VERTICAL) {
            one.x = border.width() * ratio + border.left();
            one.y = border.top();
            two.x = border.width() * ratio + border.left();
            two.y = border.bottom();
        }
        Line line = new Line(one, two);
        if (direction == Line.Direction.HORIZONTAL) {
            line.setAttachLineStart(border.lineLeft);
            line.setAttachLineEnd(border.lineRight);
            line.setUpperLine(border.lineBottom);
            line.setLowerLine(border.lineTop);
        } else if (direction == Line.Direction.VERTICAL) {
            line.setAttachLineStart(border.lineTop);
            line.setAttachLineEnd(border.lineBottom);
            line.setUpperLine(border.lineRight);
            line.setLowerLine(border.lineLeft);
        }
        return line;
    }

    static List<Border> cutBorder(Border border, Line line) {
        ArrayList<Border> list = new ArrayList<Border>();
        if (line.getDirection() == Line.Direction.HORIZONTAL) {
            Border one = new Border(border);
            one.lineBottom = line;
            list.add(one);
            Border two = new Border(border);
            two.lineTop = line;
            list.add(two);
        } else if (line.getDirection() == Line.Direction.VERTICAL) {
            Border one = new Border(border);
            one.lineRight = line;
            list.add(one);
            Border two = new Border(border);
            two.lineLeft = line;
            list.add(two);
        }
        return list;
    }

    static List<Border> cutBorderCross(Border border, Line horizontal, Line vertical) {
        ArrayList<Border> list = new ArrayList<Border>();
        Border one = new Border(border);
        one.lineBottom = horizontal;
        one.lineRight = vertical;
        list.add(one);
        Border two = new Border(border);
        two.lineBottom = horizontal;
        two.lineLeft = vertical;
        list.add(two);
        Border three = new Border(border);
        three.lineTop = horizontal;
        three.lineRight = vertical;
        list.add(three);
        Border four = new Border(border);
        four.lineTop = horizontal;
        four.lineLeft = vertical;
        list.add(four);
        return list;
    }

    static Matrix createMatrix(Border border, Bitmap bitmap, float extraSize) {
        return BorderUtil.createMatrix(border, bitmap.getWidth(), bitmap.getHeight(), extraSize);
    }

    static Matrix createMatrix(Border border, Drawable drawable, float extraSize) {
        return BorderUtil.createMatrix(border, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight(), extraSize);
    }

    static Matrix createMatrix(Border border, int width, int height, float extraSize) {
        RectF rectF = border.getRect();
        Matrix matrix = new Matrix();
        float offsetX = rectF.centerX() - (float)(width / 2);
        float offsetY = rectF.centerY() - (float)(height / 2);
        matrix.postTranslate(offsetX, offsetY);
        float scale = (float)width * rectF.height() > rectF.width() * (float)height ? (rectF.height() + extraSize) / (float)height : (rectF.width() + extraSize) / (float)width;
        matrix.postScale(scale, scale, rectF.centerX(), rectF.centerY());
        return matrix;
    }
}

