/*
 * Decompiled with CFR 0.152.
 */
package com.flyco.roundview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.flyco.roundview.RoundViewDelegate;

public class RoundFrameLayout
extends FrameLayout {
    private RoundViewDelegate delegate;

    public RoundFrameLayout(Context context) {
        this(context, null);
    }

    public RoundFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.delegate = new RoundViewDelegate((View)this, context, attrs);
    }

    public RoundViewDelegate getDelegate() {
        return this.delegate;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.delegate.isWidthHeightEqual() && this.getWidth() > 0 && this.getHeight() > 0) {
            int max = Math.max(this.getWidth(), this.getHeight());
            int measureSpec = View.MeasureSpec.makeMeasureSpec((int)max, (int)0x40000000);
            super.onMeasure(measureSpec, measureSpec);
            return;
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.delegate.isRadiusHalfHeight()) {
            this.delegate.setCornerRadius(this.getHeight() / 2);
        } else {
            this.delegate.setBgSelector();
        }
    }
}

