/*
 * Decompiled with CFR 0.152.
 */
package com.flyco.dialog.widget.popup;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.flyco.animation.BaseAnimatorSet;
import com.flyco.animation.BounceEnter.BounceLeftEnter;
import com.flyco.animation.FadeExit.FadeExit;
import com.flyco.dialog.R;
import com.flyco.dialog.utils.CornerUtils;
import com.flyco.dialog.utils.StatusBarUtils;
import com.flyco.dialog.view.TriangleView;
import com.flyco.dialog.widget.internal.InternalBasePopup;
import com.nineoldandroids.view.ViewHelper;

public class BubblePopup
extends InternalBasePopup<BubblePopup> {
    private View mWrappedView;
    private LinearLayout mLlContent;
    private TriangleView mTriangleView;
    private RelativeLayout.LayoutParams mLayoutParams;
    private int mBubbleColor;
    private int mCornerRadius;
    private int mMarginLeft;
    private int mMarginRight;

    public BubblePopup(Context context, View wrappedView) {
        super(context);
        this.mWrappedView = wrappedView;
        this.showAnim((BaseAnimatorSet)new BounceLeftEnter());
        this.dismissAnim((BaseAnimatorSet)new FadeExit());
        this.dimEnabled(false);
        this.bubbleColor(Color.parseColor((String)"#BB000000"));
        this.cornerRadius(5.0f);
        this.margin(8.0f, 8.0f);
        this.gravity(48);
    }

    @Override
    public View onCreateView() {
        View inflate = View.inflate((Context)this.mContext, (int)R.layout.popup_bubble, null);
        this.mLlContent = (LinearLayout)inflate.findViewById(R.id.ll_content);
        this.mTriangleView = (TriangleView)inflate.findViewById(R.id.triangle_view);
        this.mLlContent.addView(this.mWrappedView);
        this.mLayoutParams = (RelativeLayout.LayoutParams)this.mLlContent.getLayoutParams();
        return inflate;
    }

    @Override
    public void setUiBeforShow() {
        this.mLlContent.setBackgroundDrawable(CornerUtils.cornerDrawable(this.mBubbleColor, this.mCornerRadius));
        this.mLayoutParams.setMargins(this.mMarginLeft, 0, this.mMarginRight, 0);
        this.mLlContent.setLayoutParams((ViewGroup.LayoutParams)this.mLayoutParams);
        this.mTriangleView.setColor(this.mBubbleColor);
        this.mTriangleView.setGravity(this.mGravity == 48 ? 80 : 48);
    }

    @Override
    public void onLayoutObtain() {
        ViewHelper.setX((View)this.mTriangleView, (float)(this.mX - this.mTriangleView.getWidth() / 2));
        if (this.mGravity == 48) {
            int y = this.mY - this.mTriangleView.getHeight();
            ViewHelper.setY((View)this.mTriangleView, (float)y);
            ViewHelper.setY((View)this.mLlContent, (float)(y - this.mLlContent.getHeight()));
        } else {
            ViewHelper.setY((View)this.mTriangleView, (float)this.mY);
            ViewHelper.setY((View)this.mLlContent, (float)(this.mY + this.mTriangleView.getHeight()));
        }
        int availableLeft = this.mX - this.mLayoutParams.leftMargin;
        int availableRight = this.mDisplayMetrics.widthPixels - this.mX - this.mLayoutParams.rightMargin;
        int x = 0;
        int contentWidth = this.mLlContent.getWidth();
        x = contentWidth / 2 <= availableLeft && contentWidth / 2 <= availableRight ? this.mX - contentWidth / 2 : (availableLeft <= availableRight ? this.mLayoutParams.leftMargin : this.mDisplayMetrics.widthPixels - (contentWidth + this.mLayoutParams.rightMargin));
        ViewHelper.setX((View)this.mLlContent, (float)x);
    }

    @Override
    public BubblePopup anchorView(View anchorView) {
        if (anchorView != null) {
            this.mAnchorView = anchorView;
            int[] location = new int[2];
            this.mAnchorView.getLocationOnScreen(location);
            this.mX = location[0] + anchorView.getWidth() / 2;
            this.mY = this.mGravity == 48 ? location[1] - StatusBarUtils.getHeight(this.mContext) - this.dp2px(1.0f) : location[1] - StatusBarUtils.getHeight(this.mContext) + anchorView.getHeight() + this.dp2px(1.0f);
        }
        return this;
    }

    public BubblePopup bubbleColor(int bubbleColor) {
        this.mBubbleColor = bubbleColor;
        return this;
    }

    public BubblePopup cornerRadius(float cornerRadius) {
        this.mCornerRadius = this.dp2px(cornerRadius);
        return this;
    }

    public BubblePopup margin(float marginLeft, float marginRight) {
        this.mMarginLeft = this.dp2px(marginLeft);
        this.mMarginRight = this.dp2px(marginRight);
        return this;
    }
}

