package com.flybits.android.push.db.dao

import android.arch.persistence.db.SupportSQLiteQuery
import android.arch.persistence.room.*
import android.arch.persistence.room.OnConflictStrategy.REPLACE
import com.flybits.android.push.models.PushData

/**
 * Defines basic CRUD operations for inserting and retrieving [PushData].
 *
 */
@Dao
interface PushDataDAO {

    @Insert(onConflict = REPLACE)
    fun insert(pushDataList: List<PushData>)

    @Insert(onConflict = REPLACE)
    fun insert(pushData: PushData)

    @Update
    fun update(pushData: PushData)

    @Query("DELETE FROM pushData")
    fun clear()

    @Delete
    fun delete(pushData: PushData)

    @Query("DELETE FROM pushData WHERE id IN (:ids)")
    fun deleteByIds(ids: List<String>)

    @Query("DELETE FROM pushData WHERE id = :id")
    fun deleteById(id: String)

    @Query("SELECT * FROM pushData LIMIT :offset, :limit")
    fun get(limit: Int, offset: Int = 0): List<PushData>

    @Query("SELECT * FROM pushData WHERE id IN (:ids) LIMIT :limit")
    fun getByCachedIds(ids: List<String>, limit: Int): List<PushData>

    @Query("SELECT * FROM pushData WHERE id = :id")
    fun getById(id: String): PushData

    @RawQuery(observedEntities = [PushData::class])
    fun getRaw(query: SupportSQLiteQuery): List<PushData>
}