package com.flybits.android.push.db.converters

import android.arch.persistence.room.TypeConverter
import com.flybits.commons.library.logging.Logger
import org.json.JSONException
import org.json.JSONObject

internal object StringJsonConverter{

    @TypeConverter
    @JvmStatic
    fun convertJsonToString(json : JSONObject) : String {
        return json.toString()
    }

    @TypeConverter
    @JvmStatic
    fun convertStringToJson(json : String) : JSONObject{
        try{
            return JSONObject(json)
        }catch (e : JSONException){
            Logger
                .appendTag("RoomConverter")
                .exception("StringJsonConverter#convertStringToJson", e)
        }
        return JSONObject()
    }
}