/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LocalizedValue
implements Parcelable {
    private HashMap<String, String> localizedValue;
    private String defaultLanguage;
    private String deviceDefaultLanguage;
    public static final Parcelable.Creator<LocalizedValue> CREATOR = new Parcelable.Creator<LocalizedValue>(){

        public LocalizedValue createFromParcel(Parcel in) {
            return new LocalizedValue(in);
        }

        public LocalizedValue[] newArray(int size) {
            return new LocalizedValue[size];
        }
    };

    public LocalizedValue(@NonNull String entityDefaultLanguage, @NonNull String deviceDefaultLanguage) throws InvalidParameterException {
        this.checkLanguageConditions(deviceDefaultLanguage);
        this.checkLanguageConditions(entityDefaultLanguage);
        this.localizedValue = new HashMap();
        this.defaultLanguage = entityDefaultLanguage;
        this.deviceDefaultLanguage = deviceDefaultLanguage;
    }

    public LocalizedValue(Parcel in) {
        this(in.readString(), in.readString());
        int hashMapSize = in.readInt();
        for (int i = 0; i < hashMapSize; ++i) {
            this.localizedValue.put(in.readString(), in.readString());
        }
    }

    public void addValue(@NonNull String language, @NonNull String value) throws InvalidParameterException {
        this.checkLanguageConditions(language);
        this.localizedValue.put(language, value);
    }

    public String getDeviceDefaultLanguage() {
        return this.deviceDefaultLanguage;
    }

    public String getEntityDefaultLanguage() {
        return this.defaultLanguage;
    }

    public ArrayList<String> getListOfSupportedLanguages() {
        return new ArrayList<String>(this.localizedValue.keySet());
    }

    public String getValue() {
        if (this.localizedValue.containsKey(this.deviceDefaultLanguage)) {
            return this.localizedValue.get(this.deviceDefaultLanguage);
        }
        if (this.localizedValue.containsKey(this.defaultLanguage)) {
            return this.localizedValue.get(this.defaultLanguage);
        }
        if (this.localizedValue.size() > 0) {
            Map.Entry<String, String> entry = this.localizedValue.entrySet().iterator().next();
            return entry.getValue();
        }
        return null;
    }

    public String getValue(String language) {
        if (language != null && this.localizedValue.containsKey(language)) {
            return this.localizedValue.get(language);
        }
        return null;
    }

    public void removeProperty(@NonNull String language) {
        this.localizedValue.remove(language);
    }

    private void checkLanguageConditions(String language) throws InvalidParameterException {
        if (language == null || language.length() != 2) {
            throw new InvalidParameterException("You language must be 2 character long such as \"en\"");
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.defaultLanguage);
        dest.writeString(this.deviceDefaultLanguage);
        dest.writeInt(this.localizedValue != null ? this.localizedValue.size() : 0);
        for (Map.Entry<String, String> entry : this.localizedValue.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalizedValue) {
            LocalizedValue localizedValueOther = (LocalizedValue)obj;
            return localizedValueOther.defaultLanguage.equals(this.defaultLanguage) && localizedValueOther.deviceDefaultLanguage.equals(this.deviceDefaultLanguage) && localizedValueOther.localizedValue.equals(this.localizedValue);
        }
        return false;
    }

    public String toString() {
        return String.format("{defaultLanguage: %s, deviceDefaultLanguage: %s, localizedValue: %s}", this.defaultLanguage, this.deviceDefaultLanguage, this.localizedValue);
    }
}

