/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins.carrier;

import android.content.Context;
import android.os.Bundle;
import android.telephony.TelephonyManager;
import androidx.work.WorkerParameters;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.models.ContextData;
import com.flybits.context.plugins.carrier.CarrierData;
import com.flybits.context.services.FlybitsContextPluginsWorker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/flybits/context/plugins/carrier/CarrierContextPluginWorker;", "Lcom/flybits/context/services/FlybitsContextPluginsWorker;", "context", "Landroid/content/Context;", "workerParameters", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "getData", "Lcom/flybits/context/models/ContextData;", "getRequiredPermissions", "", "", "()[Ljava/lang/String;", "initialize", "", "bundle", "Landroid/os/Bundle;", "isSupported", "", "context_release"})
public final class CarrierContextPluginWorker
extends FlybitsContextPluginsWorker {
    @Override
    @NotNull
    public ContextData getData() {
        Logger.appendTag((String)"PluginCarrier").d("Fetching Carrier Data... ");
        Object tel = this.getApplicationContext().getSystemService("phone");
        if (!(tel instanceof TelephonyManager)) {
            throw (Throwable)new NullPointerException("getSystemService() returns null");
        }
        String simOperator = ((TelephonyManager)tel).getSimOperator();
        return new CarrierData(simOperator);
    }

    @Override
    @NotNull
    public String[] getRequiredPermissions() {
        return new String[]{"android.permission.READ_PHONE_STATE"};
    }

    @Override
    public void initialize(@Nullable Bundle bundle) {
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    public CarrierContextPluginWorker(@NotNull Context context, @NotNull WorkerParameters workerParameters) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)workerParameters, (String)"workerParameters");
        super(context, workerParameters);
    }
}

