/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.models;

import com.flybits.context.models.RulePredicate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RulePredicateQuery {
    private String stringRepresentation;
    private HashMap<String, String> mapOfHash;

    private RulePredicateQuery(Builder builder) {
        this.stringRepresentation = builder.predicateAsString;
        this.mapOfHash = builder.mapOfHash;
    }

    public HashMap<String, String> getMapOfRulePredicate() {
        return this.mapOfHash;
    }

    public String getQuery() {
        return "(" + this.stringRepresentation + ")";
    }

    public static class Builder {
        private String predicateAsString;
        private HashMap<String, String> mapOfHash;

        public Builder(RulePredicate predicate) {
            this.predicateAsString = predicate.getString();
            this.mapOfHash = new HashMap();
            this.addPredicateAsData(predicate.getPluginData());
        }

        public RulePredicateQuery build() {
            return new RulePredicateQuery(this);
        }

        public Builder and(RulePredicate predicate) {
            this.predicateAsString = this.predicateAsString + " And " + predicate.getString();
            this.addPredicateAsData(predicate.getPluginData());
            return this;
        }

        public Builder and(RulePredicateQuery query) {
            this.predicateAsString = this.predicateAsString + " And " + query.getQuery();
            this.addPredicateAsData(query.getMapOfRulePredicate());
            return this;
        }

        public Builder or(RulePredicate predicate) {
            this.predicateAsString = this.predicateAsString + " Or " + predicate.getString();
            this.addPredicateAsData(predicate.getPluginData());
            return this;
        }

        public Builder or(RulePredicateQuery query) {
            this.predicateAsString = this.predicateAsString + " Or " + query.getQuery();
            this.addPredicateAsData(query.getMapOfRulePredicate());
            return this;
        }

        private void addPredicateAsData(HashMap<String, String> mapOfPredicateData) {
            if (mapOfPredicateData != null && mapOfPredicateData.size() > 0) {
                Iterator<Map.Entry<String, String>> it = mapOfPredicateData.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> pair = it.next();
                    this.mapOfHash.put(pair.getKey(), pair.getValue());
                    it.remove();
                }
            }
        }
    }
}

