/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.deserializations;

import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.Pagination;
import com.flybits.context.models.RuleEvalutated;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeserializeEvaluatedRules
extends IDeserializer<PagedResponse<RuleEvalutated>> {
    public String toJson(PagedResponse<RuleEvalutated> obj) {
        if (obj == null || obj.getItems() == null || obj.getItems().size() == 0) {
            return "[]";
        }
        JSONArray array = new JSONArray();
        for (RuleEvalutated rule : obj.getItems()) {
            JSONObject object = new JSONObject();
            try {
                object.put("id", (Object)rule.getId());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            try {
                object.put("name", (Object)rule.getName());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            try {
                object.put("lastEvaluated", rule.getEvaluatedTime());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            try {
                object.put("lastResult", rule.isLastResult());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            array.put((Object)object);
        }
        return array.toString();
    }

    public PagedResponse<RuleEvalutated> fromJson(JSONObject jsonObject) {
        return null;
    }

    public PagedResponse<RuleEvalutated> fromJson(JSONArray jsonArray) {
        try {
            ArrayList<RuleEvalutated> rules = new ArrayList<RuleEvalutated>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject elementObj = jsonArray.getJSONObject(i);
                String id = null;
                String name = null;
                String data = null;
                boolean lastResult = false;
                long timestamp = -1L;
                if (!elementObj.isNull("id")) {
                    id = elementObj.getString("id");
                }
                if (!elementObj.isNull("name")) {
                    name = elementObj.getString("name");
                }
                if (!elementObj.isNull("lastEvaluated")) {
                    timestamp = elementObj.getLong("lastEvaluated");
                }
                if (!elementObj.isNull("lastResult")) {
                    lastResult = elementObj.getBoolean("lastResult");
                }
                if (!elementObj.isNull("data")) {
                    Object jsonType = elementObj.get("data");
                    data = jsonType instanceof JSONObject ? elementObj.getJSONObject("data").toString() : (jsonType instanceof JSONArray ? elementObj.getJSONArray("data").toString() : elementObj.getString("data"));
                }
                rules.add(new RuleEvalutated(id, timestamp, lastResult, name, data));
            }
            return new PagedResponse(rules, new Pagination((long)jsonArray.length(), 0L, (long)jsonArray.length()));
        }
        catch (NullPointerException | JSONException e) {
            return null;
        }
    }
}

