/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.User;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.context.ContextPluginsService;
import com.flybits.context.ContextRulesService;
import com.flybits.context.ContextScope;
import com.flybits.context.ContextUploadingService;
import com.flybits.context.db.ContextDatabase;
import com.flybits.context.models.BasicData;
import com.flybits.context.models.ContextData;
import com.flybits.context.models.ContextPriority;
import com.flybits.context.plugins.FlybitsContextPlugin;
import com.flybits.context.services.FlybitsContextPluginService;
import com.flybits.context.services.FlybitsContextPluginsWorker;
import com.flybits.context.utils.ContextUtilities;
import com.flybits.internal.db.CommonsDatabase;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.OneoffTask;
import com.google.android.gms.gcm.PeriodicTask;
import com.google.android.gms.gcm.Task;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ContextManager {
    public static final String API_CONTEXT_DATA = "/context/ctxdata";
    private static final String _TAG = "ContextManager";

    public static <T extends ContextData> ObjectResult<T> getData(@NonNull Context context, @NonNull String pluginID, @NonNull Class<T> subclass, ObjectResultCallback<T> callback) throws InvalidParameterException {
        block5: {
            if (context == null) {
                throw new InvalidParameterException("The Context parameter must not be null");
            }
            if (pluginID == null) {
                throw new InvalidParameterException("The pluginId parameter must not be null");
            }
            if (subclass == null) {
                throw new InvalidParameterException("The Class parameter must not be null");
            }
            try {
                ContextData contextData = (ContextData)subclass.newInstance();
            }
            catch (Exception e) {
                if (!(e instanceof InstantiationException)) break block5;
                throw new InvalidParameterException("The .Class file that will be instantiated must contain a constructor with no parameter for this method to be successfully processed");
            }
        }
        return ContextManager.getDataPrivate(context, pluginID, subclass, callback);
    }

    public static BasicResult flushContextData(final @NonNull Context context, BasicResultCallback callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult basicResult = new BasicResult(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                boolean isSuccessful = ContextManager.flushContextData(context);
                Result tempStatus = null;
                tempStatus = isSuccessful ? new Result(200, "") : new Result(new FlybitsException("Error Updating Context"), "");
                Result resultStatus = tempStatus;
                basicResult.setResult(resultStatus);
            }
        });
        return basicResult;
    }

    public static boolean flushContextData(@NonNull Context context) {
        if (context == null) {
            return false;
        }
        boolean isSuccessful = false;
        List<BasicData> dataPlugins = ContextDatabase.getDatabase(context).basicDataDao().getAllNotSent();
        String jsonToSend = ContextUtilities.getContextData(dataPlugins);
        if (jsonToSend != null && jsonToSend.length() > 2) {
            try {
                Result result = FlyAway.post((Context)context, (String)API_CONTEXT_DATA, (String)jsonToSend, null, (String)"FlushUtilities.flushContext", null);
                if (result.getStatus() == RequestStatus.COMPLETED) {
                    for (BasicData data : dataPlugins) {
                        data.setSent(true);
                        ContextDatabase.getDatabase(context).basicDataDao().update(data);
                    }
                    isSuccessful = true;
                } else {
                    Logger.setTag((String)_TAG).e("Updated FlybitsContext in Server: Failed");
                }
            }
            catch (FlybitsException e) {
                Logger.exception((String)"FlushUtilities.flushContext", (Exception)((Object)e));
            }
        }
        return isSuccessful;
    }

    public static void refresh(Context mContext, FlybitsContextPlugin plugin) {
        Executors.newSingleThreadExecutor().execute(() -> ContextManager.refreshSync(mContext, plugin));
    }

    public static void refreshSync(Context mContext, FlybitsContextPlugin plugin) {
        User user = CommonsDatabase.getDatabase((Context)mContext).userDao().getSingle();
        if (user != null && user.isOptedIn()) {
            plugin.onRefresh(mContext);
        }
        ContextDatabase.getDatabase(mContext).flybitsContextPluginDAO().insert(plugin);
    }

    public static void start(Context mContext, FlybitsContextPlugin plugin) {
        Executors.newSingleThreadExecutor().execute(() -> ContextManager.startSync(mContext, plugin));
    }

    public static void startSync(Context mContext, FlybitsContextPlugin plugin) {
        User user = CommonsDatabase.getDatabase((Context)mContext).userDao().getSingle();
        if (plugin.getContextPluginRetriever().getGenericSuperclass() == FlybitsContextPluginsWorker.class) {
            if (user != null && user.isOptedIn()) {
                plugin.onStart(mContext);
            }
            ContextDatabase.getDatabase(mContext).flybitsContextPluginDAO().insert(plugin);
        } else if (plugin.getContextPluginRetriever().getGenericSuperclass() == FlybitsContextPluginService.class) {
            Intent intent = new Intent(mContext, plugin.getService());
            if (ContextUtilities.isServiceDefined(mContext, intent)) {
                if (user != null && user.isOptedIn()) {
                    plugin.onStart(mContext);
                }
                ContextDatabase.getDatabase(mContext).flybitsContextPluginDAO().insert(plugin);
            } else {
                Logger.setTag((String)_TAG).e("Cannot start Context Plugin: In order to start the plugin you need to add the corresponding " + plugin.getService().getSimpleName() + " service in your manifest.");
            }
        }
    }

    static void resume(Context mContext, FlybitsContextPlugin plugin) {
        Executors.newSingleThreadExecutor().execute(() -> ContextManager.resumeSync(mContext, plugin));
    }

    static void resumeSync(Context mContext, FlybitsContextPlugin plugin) {
        User user = CommonsDatabase.getDatabase((Context)mContext).userDao().getSingle();
        ContextManager.resumeSync(mContext, plugin, user);
    }

    static void resumeSync(Context mContext, FlybitsContextPlugin plugin, User user) {
        if (plugin.getContextPluginRetriever().getGenericSuperclass() == FlybitsContextPluginsWorker.class) {
            if (user != null && user.isOptedIn()) {
                plugin.onStart(mContext);
                ContextDatabase.getDatabase(mContext).flybitsContextPluginDAO().update(plugin);
            }
        } else if (plugin.getContextPluginRetriever().getGenericSuperclass() == FlybitsContextPluginService.class) {
            Intent intent = new Intent(mContext, plugin.getService());
            if (ContextUtilities.isServiceDefined(mContext, intent)) {
                if (user != null && user.isOptedIn()) {
                    plugin.onStart(mContext);
                    ContextDatabase.getDatabase(mContext).flybitsContextPluginDAO().update(plugin);
                }
            } else {
                ContextDatabase.getDatabase(mContext).flybitsContextPluginDAO().delete(plugin);
                Logger.setTag((String)_TAG).e("Cannot start Context Plugin: In order to start the plugin you need to add the corresponding " + plugin.getService().getSimpleName() + " service in your manifest.");
            }
        }
    }

    public static void stop(Context mContext, FlybitsContextPlugin plugin) {
        Executors.newSingleThreadExecutor().execute(() -> ContextManager.stopSync(mContext, plugin));
    }

    public static void stopSync(Context mContext, FlybitsContextPlugin plugin) {
        plugin.onStop(mContext);
        ContextDatabase.getDatabase(mContext).flybitsContextPluginDAO().delete(plugin);
    }

    public static void pause(Context mContext, FlybitsContextPlugin flybitsContextPlugin) {
        Executors.newSingleThreadExecutor().execute(() -> ContextManager.pauseSync(mContext, flybitsContextPlugin));
    }

    public static void pauseSync(Context mContext, FlybitsContextPlugin flybitsContextPlugin) {
        flybitsContextPlugin.onStop(mContext);
        ContextDatabase.getDatabase(mContext).flybitsContextPluginDAO().update(flybitsContextPlugin);
    }

    public static void pauseAll(Context mContext) {
        Executors.newSingleThreadExecutor().execute(() -> ContextManager.pauseAllSync(mContext));
    }

    public static void pauseAllSync(Context mContext) {
        List<FlybitsContextPlugin> flybitsContextPluginList = ContextDatabase.getDatabase(mContext).flybitsContextPluginDAO().getAll();
        for (FlybitsContextPlugin plugin : flybitsContextPluginList) {
            ContextManager.pauseSync(mContext, plugin);
        }
    }

    public static void resumeAll(Context mContext) {
        Executors.newSingleThreadExecutor().execute(() -> ContextManager.resumeAllSync(mContext));
    }

    public static void resumeAllSync(Context mContext) {
        User user = CommonsDatabase.getDatabase((Context)mContext).userDao().getSingle();
        List<FlybitsContextPlugin> flybitsContextPluginList = ContextDatabase.getDatabase(mContext).flybitsContextPluginDAO().getAll();
        for (FlybitsContextPlugin plugin : flybitsContextPluginList) {
            ContextManager.resumeSync(mContext, plugin, user);
        }
    }

    public static void registerForRules(Context mContext, long timeInSeconds, long timeInSecondsFlex, TimeUnit unit) {
        GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)mContext);
        PeriodicTask.Builder task = new PeriodicTask.Builder().setTag("Context_Rules").setUpdateCurrent(true).setPersisted(true).setPeriod(unit.toSeconds(timeInSeconds)).setService(ContextRulesService.class);
        mGcmNetworkManager.schedule((Task)task.build());
        Logger.setTag((String)_TAG).d("Activated: Context_Rules, Time to Refresh: " + timeInSeconds);
    }

    static void registerForPluginUpdates(Context mContext, HashMap<String, String> listOfClass, long timeToRefreshInSec) {
        int listOfClassSize = listOfClass.size();
        SharedPreferences.Editor preferences = ContextScope.getContextPreferences(mContext).edit();
        preferences.putInt("ContextPlugin-size", listOfClassSize);
        preferences.putLong("ContextPlugin-refreshTime", timeToRefreshInSec);
        Bundle bundle = new Bundle();
        bundle.putInt("listOfItems", listOfClassSize);
        int i = 0;
        Iterator<Map.Entry<String, String>> it = listOfClass.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> pair = it.next();
            String key = pair.getKey();
            bundle.putString("item" + i, key);
            preferences.putString("item" + i, key);
            String value = pair.getValue();
            bundle.putString("class" + i, value);
            bundle.putString("value" + i, value);
            it.remove();
            ++i;
        }
        preferences.apply();
        GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)mContext);
        OneoffTask oneTimeTask = new OneoffTask.Builder().setService(ContextPluginsService.class).setTag("Context_Plugin_Once").setExecutionWindow(0L, 30L).setRequiredNetwork(2).build();
        mGcmNetworkManager.schedule((Task)oneTimeTask);
        PeriodicTask.Builder task = new PeriodicTask.Builder().setExtras(bundle).setTag("Context_Plugin").setUpdateCurrent(true).setPersisted(true).setPeriod(timeToRefreshInSec).setService(ContextPluginsService.class);
        mGcmNetworkManager.schedule((Task)task.build());
        Logger.setTag((String)_TAG).d("Activated: Context_Plugin - Time to Refresh: 90");
    }

    static void registerUploadingContext(Context mContext, ContextPriority priority, long time, long timeInSecondsFlex, TimeUnit unit) {
        Bundle bundle = new Bundle();
        bundle.putInt("priority", priority.getKey());
        GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)mContext);
        PeriodicTask.Builder task = new PeriodicTask.Builder().setExtras(bundle).setTag("Context_Uploading").setUpdateCurrent(true).setPersisted(true).setRequiredNetwork(0).setPeriod(unit.toSeconds(time)).setService(ContextUploadingService.class);
        mGcmNetworkManager.schedule((Task)task.build());
        Logger.setTag((String)_TAG).d("Activated: Context_Uploading with Priority: " + priority.getKey() + ", Time to Refresh: " + time);
    }

    static void unregisterFromRuleCollection(Context mContext) {
        Intent intent = new Intent(mContext, ContextRulesService.class);
        if (ContextUtilities.isServiceDefined(mContext, intent)) {
            GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)mContext);
            try {
                mGcmNetworkManager.cancelTask("Context_Rules", ContextRulesService.class);
                Logger.setTag((String)_TAG).d("UnActivated: Context_Rules");
            }
            catch (IllegalArgumentException ex) {
                Logger.exception((String)"ContextManager.unregisterFromRuleCollection", (Exception)ex);
            }
        }
        Logger.setTag((String)_TAG).d("unregisterFromRuleCollection Completed");
    }

    static void unregisterUploadingContext(Context mContext) {
        Intent intent = new Intent(mContext, ContextUploadingService.class);
        if (ContextUtilities.isServiceDefined(mContext, intent)) {
            GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)mContext);
            try {
                mGcmNetworkManager.cancelTask("Context_Uploading", ContextUploadingService.class);
                Logger.setTag((String)_TAG).d("UnActivated: Context_Uploading");
            }
            catch (IllegalArgumentException ex) {
                Logger.exception((String)"ContextManager.unregisterUploadingContext", (Exception)ex);
            }
        }
        Logger.setTag((String)_TAG).d("unregisterUploadingContext Completed");
    }

    static void unregisterPluginContext(Context mContext) {
        Intent intent = new Intent(mContext, ContextPluginsService.class);
        if (ContextUtilities.isServiceDefined(mContext, intent)) {
            GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)mContext);
            try {
                mGcmNetworkManager.cancelTask("Context_Plugin", ContextPluginsService.class);
                Logger.setTag((String)_TAG).d("UnActivated: Context_Plugin");
            }
            catch (IllegalArgumentException ex) {
                Logger.exception((String)"ContextManager.unregisterPluginContext", (Exception)ex);
            }
        }
        Logger.setTag((String)_TAG).d("ContextManager.unregisterPluginContext Completed");
    }

    @Nullable
    static <T extends ContextData> ObjectResult<T> getDataPrivate(final @NonNull Context context, final @NonNull String pluginID, final @NonNull Class<T> subclass, ObjectResultCallback<T> callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult objectResult = new ObjectResult(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                BasicData dataFromCursor = ContextDatabase.getDatabase(context).basicDataDao().get(pluginID);
                if (dataFromCursor != null && dataFromCursor.getValueAsString() != null) {
                    try {
                        ContextData data = (ContextData)subclass.newInstance();
                        data.fromJson(dataFromCursor.getValueAsString());
                        data.setTime(dataFromCursor.getTimestamp());
                        Result result = new Result(200, "");
                        result.setResponse((Object)data);
                        objectResult.setResult(result);
                    }
                    catch (Exception e) {
                        objectResult.setResult(new Result(new FlybitsException(e.getMessage()), ""));
                        Logger.exception((String)"ContextManager.getData", (Exception)e);
                    }
                }
            }
        });
        return objectResult;
    }
}

