package com.flybits.concierge.smartrewards.model;

import android.graphics.Color;
import android.os.Parcel;
import android.text.TextUtils;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.models.BaseTemplate;

public class SimpleButton extends BaseTemplate {

    public LocalizedValue label;
    public String color;

    public SimpleButton() {

    }

    public SimpleButton(Parcel in) {
        super(in);
        label = in.readParcelable(LocalizedValue.class.getClassLoader());
        color = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable(label, flags);
        dest.writeString(color);
    }

    public int getColor() {
        return !TextUtils.isEmpty(color) ? Color.parseColor(color) : Color.WHITE;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<SimpleButton> CREATOR = new Creator<SimpleButton>()
    {
        @Override
        public SimpleButton createFromParcel(Parcel in)
        {
            return new SimpleButton(in);
        }

        @Override
        public SimpleButton[] newArray(int size)
        {
            return new SimpleButton[size];
        }
    };
}
