package com.flybits.concierge.smartrewards.model;

import android.graphics.Color;
import android.os.Parcel;
import android.text.TextUtils;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.models.BaseTemplate;

public class ActionTypeButton extends BaseTemplate {

    public LocalizedValue label;
    public String action;
    public String color;
    public String actionType;


    public ActionTypeButton() {

    }

    public ActionTypeButton(Parcel in) {
        super(in);
        label = in.readParcelable(LocalizedValue.class.getClassLoader());
        action = in.readString();
        color = in.readString();
        actionType = in.readString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);

        dest.writeParcelable(label, flags);
        dest.writeString(action);
        dest.writeString(color);
        dest.writeString(actionType);
    }

    public int getColor() {
        return !TextUtils.isEmpty(color) ? Color.parseColor(color) : Color.BLACK;
    }

    public static final Creator<ActionTypeButton> CREATOR = new Creator<ActionTypeButton>()
    {
        @Override
        public ActionTypeButton createFromParcel(Parcel in)
        {
            return new ActionTypeButton(in);
        }

        @Override
        public ActionTypeButton[] newArray(int size)
        {
            return new ActionTypeButton[size];
        }
    };
}