package com.flybits.concierge.smartrewards.model;

import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Parcel;
import android.text.TextUtils;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.smartrewards.utils.ColorHelper;

import java.util.List;

// ctn-flybits-optin-card
public class OptIn extends BaseTemplate {

    public LocalizedValue header;
    public LocalizedValue title;
    public LocalizedValue explanation;
    public String icon;
    public String backgroundImage;
    public String backgroundColor;
    public List<String> gradientRange;
    public SimpleButton primaryButton;
    public SimpleButton secondaryButton;
    private GradientDrawable gradientDrawable;

    public OptIn() {

    }

    public int getBackgroundColor() {
        return !TextUtils.isEmpty(backgroundColor) ? Color.parseColor(backgroundColor) : ColorHelper.INSTANCE.defaultBackgroundColor();
    }

    public GradientDrawable getGradientDrawable() {

        if (gradientRange == null || gradientRange.size() < 2) {
            return null;
        } else if (gradientDrawable != null) {
            return gradientDrawable;
        }

        gradientDrawable = ColorHelper.INSTANCE.generateGradientDrawable(gradientRange);

        return gradientDrawable;
    }

    public OptIn(Parcel in) {
        super(in);
        header = in.readParcelable(LocalizedValue.class.getClassLoader());
        title = in.readParcelable(LocalizedValue.class.getClassLoader());
        explanation = in.readParcelable(LocalizedValue.class.getClassLoader());
        icon = in.readString();
        backgroundImage = in.readString();
        backgroundColor = in.readString();
        gradientRange = in.createStringArrayList();
        primaryButton = in.readParcelable(SimpleButton.class.getClassLoader());
        secondaryButton = in.readParcelable(SimpleButton.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable(header, flags);
        dest.writeParcelable(title, flags);
        dest.writeParcelable(explanation, flags);
        dest.writeString(icon);
        dest.writeString(backgroundImage);
        dest.writeString(backgroundColor);
        dest.writeStringList(gradientRange);
        dest.writeParcelable(primaryButton, flags);
        dest.writeParcelable(secondaryButton, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<OptIn> CREATOR = new Creator<OptIn>()
    {
        @Override
        public OptIn createFromParcel(Parcel in)
        {
            return new OptIn(in);
        }

        @Override
        public OptIn[] newArray(int size)
        {
            return new OptIn[size];
        }
    };
}
