/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.smartrewards.model;

import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Parcel;
import android.os.Parcelable;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.smartrewards.model.ActionButton;
import com.flybits.concierge.smartrewards.utils.ColorHelper;
import java.util.List;

public class Benefit
extends BaseTemplate {
    public LocalizedValue title;
    public LocalizedValue explanation;
    public String sourceImage;
    public String source;
    public String header;
    public List<String> gradient;
    public String backgroundColor;
    public String url;
    public ActionButton primaryButton;
    private GradientDrawable gradientDrawable;
    private boolean expanded;
    public static final Parcelable.Creator<Benefit> CREATOR = new Parcelable.Creator<Benefit>(){

        public Benefit createFromParcel(Parcel in) {
            return new Benefit(in);
        }

        public Benefit[] newArray(int size) {
            return new Benefit[size];
        }
    };

    public Benefit() {
    }

    public Benefit(Parcel in) {
        super(in);
        this.title = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.explanation = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.sourceImage = in.readString();
        this.source = in.readString();
        this.header = in.readString();
        this.backgroundColor = in.readString();
        this.gradient = in.createStringArrayList();
        this.url = in.readString();
        this.primaryButton = (ActionButton)in.readParcelable(ActionButton.class.getClassLoader());
    }

    public int getColor() {
        return this.backgroundColor != null ? Color.parseColor((String)this.backgroundColor) : -1;
    }

    public GradientDrawable getGradientDrawable() {
        if (this.gradient == null || this.gradient.size() < 2) {
            return null;
        }
        if (this.gradientDrawable != null) {
            return this.gradientDrawable;
        }
        this.gradientDrawable = ColorHelper.INSTANCE.generateGradientDrawable(this.gradient);
        return this.gradientDrawable;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expand) {
        this.expanded = expand;
    }

    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.title, flags);
        dest.writeParcelable((Parcelable)this.explanation, flags);
        dest.writeString(this.sourceImage);
        dest.writeString(this.source);
        dest.writeString(this.header);
        dest.writeString(this.backgroundColor);
        dest.writeStringList(this.gradient);
        dest.writeString(this.url);
        dest.writeParcelable((Parcelable)this.primaryButton, flags);
    }

    public int describeContents() {
        return 0;
    }
}

