package com.flybits.concierge.smartrewards.useractionhandlers

import android.os.Parcel
import android.os.Parcelable
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.UserActionHandler
import com.flybits.concierge.smartrewards.model.Benefit
import com.flybits.concierge.smartrewards.model.Benefits
import java.lang.IllegalArgumentException

/**
 * Responsible for handling user actions for the [Benefits] content type.
 *
 */
open class BenefitUserActionHandler(): UserActionHandler<Benefit> {

    constructor(parcel: Parcel) : this()

    override fun onUserAction(action: Int, data: Benefit, flybitsNavigator: FlybitsNavigator) {
        when(action) {
            TAPPED_LEARN_MORE -> {
                data.primaryButton?.actionURL?.let {
                    flybitsNavigator.openUrl(it)
                }
            }
            else -> throw IllegalArgumentException("Invalid action, action = $action")
        }
    }

    override fun writeToParcel(parcel: Parcel, flags: Int) {
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object {
        const val TAPPED_LEARN_MORE = 0

        @JvmField
        val CREATOR = object : Parcelable.Creator<BenefitUserActionHandler> {
            override fun createFromParcel(parcel: Parcel): BenefitUserActionHandler {
                return BenefitUserActionHandler(parcel)
            }

            override fun newArray(size: Int): Array<BenefitUserActionHandler?> {
                return arrayOfNulls(size)
            }
        }
    }
}