package com.flybits.concierge.smartrewards

import android.content.Context
import android.content.SharedPreferences
import com.flybits.concierge.smartrewards.model.OptInInteraction

object InternalPreferences {

    private const val PREFS_NAME : String = "SmartRewardsConciergePrefs"

    private fun getInstance(context: Context) : SharedPreferences = context.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE)
    private fun getSaveInstance(context: Context) : SharedPreferences.Editor = getInstance(context).edit()

    fun isContentEngaged(context: Context, contentId: String) : OptInInteraction {

        val interactionString = getInstance(context).getString(contentId, null)

        return interactionString?.let { OptInInteraction.valueOf(it.toUpperCase()) } ?: OptInInteraction.NOT_ENGAGED
    }

    fun engageContent(context: Context, contentId : String, engageType : OptInInteraction) {
        getSaveInstance(context).putString(contentId, engageType.string).apply()
    }
}