package com.flybits.concierge.smartrewards.viewproviders

import android.app.Activity
import android.os.Handler
import android.support.design.widget.Snackbar
import android.support.v4.content.ContextCompat
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.bumptech.glide.request.RequestOptions
import com.flybits.android.kernel.ContentAnalytics
import com.flybits.commons.library.logging.Logger
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.FlybitsViewProvider
import com.flybits.concierge.smartrewards.InternalPreferences
import com.flybits.concierge.smartrewards.R
import com.flybits.concierge.smartrewards.model.OptIn
import com.flybits.concierge.smartrewards.views.RoundedCornerBorderButton
import com.flybits.concierge.viewholders.FlybitsViewHolder

class OptInViewProvider : FlybitsViewProvider <OptIn> {
    override fun getClassType(): Class<OptIn> {
        return OptIn::class.java
    }

    override fun getContentType(): String {
        return "ctn-flybits-optin-card"
    }

    override fun onCreateViewHolder(parent: ViewGroup): FlybitsViewHolder<OptIn> {
        return OptInViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.smartrewards_item_template_reward, parent, false))
    }

    override fun onPushOpened(model: OptIn, flybitsNavigator: FlybitsNavigator) {

    }

    // View Holder for the Benefit Card
    class OptInViewHolder (val view: View) : FlybitsViewHolder<OptIn>(view) {

        private val headerView: TextView = view.findViewById(R.id.smartrewards_item_template_reward_header)
        private val titleView: TextView = view.findViewById(R.id.smartrewards_item_template_reward_title)
        private val descriptionView: TextView = view.findViewById(R.id.smartrewards_item_template_reward_description)
        private val iconView: ImageView = view.findViewById(R.id.smartrewards_item_template_reward_icon)
        private val secondaryBtn: TextView = view.findViewById(R.id.smartrewards_item_template_reward_secondary_btn)
        private val primaryBtn: TextView = view.findViewById(R.id.smartrewards_item_template_reward_primary_btn)
        private val resultContainerView: View = view.findViewById(R.id.smartrewards_item_template_reward_result_container)
        private val resultStatusTextView: TextView = view.findViewById(R.id.smartrewards_item_template_reward_result_status)
        private val resultBtn: RoundedCornerBorderButton = view.findViewById(R.id.smartrewards_item_template_reward_result_btn)
        private val gradientView: View = view.findViewById(R.id.smartrewards_item_template_reward_gradient)
        private val backgroundView: ImageView = view.findViewById(R.id.smartrewards_item_template_reward_background_image)

        private val ctaContainerView: View = view.findViewById(R.id.smartrewards_item_template_reward_cta_container)

        private val contentView: View = (view.context as Activity).findViewById<ViewGroup>(android.R.id.content).getChildAt(0)

        override fun bindData(data: OptIn, flybitsNavigator: FlybitsNavigator) {

            resultBtn.visibility = View.GONE

            data.backgroundColor?.let {
                gradientView.setBackgroundColor(data.getBackgroundColor())
            }

            data.gradientDrawable?.let {
                gradientView.background = it
            }

            headerView.text = data.header.value
            titleView.text = data.title.value
            descriptionView.text = data.explanation.value

            Glide.with(iconView.context).load(data.icon).into(iconView)

            gradientView.alpha = 1.0f
            changeStatus(InternalPreferences.isContentEngaged(view.context, data.content.id))

            data.backgroundImage?.let {
                backgroundView.visibility = View.VISIBLE
                gradientView.alpha = 0.6f
                Glide.with(view.context).load(it).apply(RequestOptions().centerCrop()).into(backgroundView)
            }

            primaryBtn.visibility = View.INVISIBLE
            if (data.primaryButton.label != null) {
                primaryBtn.visibility = View.VISIBLE
                primaryBtn.text = data.primaryButton.label.value
                primaryBtn.setBackgroundColor(data.primaryButton.getColor())
                primaryBtn.setOnClickListener {

                    changeStatus(true)

                    val snackbar : Snackbar = Snackbar.make(contentView, data.primaryButton.label.value, Snackbar.LENGTH_SHORT)
                    snackbar.setAction(R.string.smartrewards_undo) {
                        changeStatus(false)
                    }
                    snackbar.addCallback(SnackbarButtonCallback(data.content.id))
                    snackbar.show()
                }
            }

            secondaryBtn.visibility = View.INVISIBLE
            if (data.secondaryButton.label != null) {
                secondaryBtn.visibility = View.VISIBLE
                secondaryBtn.text = data.secondaryButton.label.value
                secondaryBtn.setBackgroundColor(data.secondaryButton.getColor())
                secondaryBtn.setOnClickListener {

                    changeStatus(true)

                    val snackbar : Snackbar = Snackbar.make(contentView, data.secondaryButton.label.value, Snackbar.LENGTH_SHORT)
                    snackbar.setAction(R.string.smartrewards_undo) {
                        changeStatus(false)
                    }
                    snackbar.addCallback(SnackbarButtonCallback(data.content.id, false))
                    snackbar.show()
                }
            }
        }

        // change the view based on how the user interacts with it (past and present)
        private fun changeStatus(engaged : Boolean) {
            resultContainerView.visibility = if(engaged) View.VISIBLE else View.GONE
            ctaContainerView.visibility = if(engaged) View.GONE else View.VISIBLE
            if (engaged){
                resultStatusTextView.text = view.context.getString(R.string.smartrewards_item_template_reward_pending) ?: ""
            }
        }
    }

    class SnackbarButtonCallback(private val contentId: String, private val track: Boolean = true) : Snackbar.Callback() {
        override fun onDismissed(snackbar: Snackbar?, event: Int) {

            // with every add there must be a remove.
            snackbar?.removeCallback(this)

            if (event != Snackbar.Callback.DISMISS_EVENT_ACTION) { // this dismiss is due to a non-undo action and should confirm the action
                snackbar?.let { // using a let because we need the context from it
                    InternalPreferences.engageContent(it.context, contentId)
                    if (track) {
                        val analytics = ContentAnalytics(it.context)
                        analytics.trackEngaged(contentId)

                        // wait before sending the new events up to the server
                        Handler().postDelayed({
                            // if the device is online, send the data right away
                            if (com.pierfrancescosoffritti.androidyoutubeplayer.utils.Utils.isOnline(it.context)) {
                                analytics.flush(null, true)
                            }
                        },500)
                    }
                }
            }
        }
    }
}