package com.flybits.concierge.smartrewards.model;

import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Parcel;
import android.text.TextUtils;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.smartrewards.utils.ColorHelper;

import java.util.List;

// ctn-flybits-reward-confirmation-card
public class Confirmation extends BaseTemplate {

    public LocalizedValue header;
    public LocalizedValue title;
    public LocalizedValue explanation;
    public String icon;
    public ActionTypeButton primaryButton;
    public String backgroundImage;
    public String backgroundColor;
    public List<String> gradientRange;
    public String rewardStatus;
    private GradientDrawable gradientDrawable;

    public Confirmation() {

    }

    public Confirmation(Parcel in) {
        super(in);
        header = in.readParcelable(LocalizedValue.class.getClassLoader());
        title = in.readParcelable(LocalizedValue.class.getClassLoader());
        explanation = in.readParcelable(LocalizedValue.class.getClassLoader());
        icon = in.readString();
        primaryButton = in.readParcelable(ActionTypeButton.class.getClassLoader());
        backgroundImage = in.readString();
        backgroundColor = in.readString();
        gradientRange = in.createStringArrayList();
        rewardStatus = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);

        dest.writeParcelable(header, flags);
        dest.writeParcelable(title, flags);
        dest.writeParcelable(explanation, flags);
        dest.writeString(icon);
        dest.writeParcelable(primaryButton, flags);
        dest.writeString(backgroundImage);
        dest.writeString(backgroundColor);
        dest.writeStringList(gradientRange);
        dest.writeString(rewardStatus);
    }

    public int getBackgroundColor() {
        return !TextUtils.isEmpty(backgroundColor) ? Color.parseColor(backgroundColor) : ColorHelper.INSTANCE.defaultBackgroundColor();
    }

    public GradientDrawable getGradientDrawable() {

        if (gradientRange == null || gradientRange.isEmpty()) {
            return null;
        } else if (gradientDrawable != null) {
            return gradientDrawable;
        }

        gradientDrawable = ColorHelper.INSTANCE.generateGradientDrawable(gradientRange);

        return gradientDrawable;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<Confirmation> CREATOR = new Creator<Confirmation>()
    {
        @Override
        public Confirmation createFromParcel(Parcel in)
        {
            return new Confirmation(in);
        }

        @Override
        public Confirmation[] newArray(int size)
        {
            return new Confirmation[size];
        }
    };
}
