package com.flybits.concierge.smartrewards.views

import android.content.Context
import android.graphics.Color
import android.graphics.drawable.GradientDrawable
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.FrameLayout
import android.widget.TextView
import com.flybits.concierge.smartrewards.R
import org.jetbrains.annotations.Nullable

class RoundedCornerBorderButton : FrameLayout {
    private var buttonContainerView : View
    private var buttonTextView : TextView

    // Using the old school constructors rather than the init method to prevent crashing in KitKat

    constructor(context: Context) :
            this(context, null)

    constructor(context: Context, @Nullable attrs: AttributeSet?) :
            this(context, attrs!!, 0)

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) :
            super(context, attrs, defStyleAttr) {

        // added the inflated view to the FrameLayout, and retained a reference to it.
        buttonContainerView = LayoutInflater.from(context).inflate(R.layout.smartrewards_view_rounded_corner_border_button, this, true)
        buttonTextView = buttonContainerView.findViewById(R.id.smartrewards_view_button_text)
    }

    /**
     * Set the [text] of the button.
     */
    fun setText(text : String) = buttonTextView.let {
        it.text = text
    }

    /**
     * Set the text [size] for the button, interpreted as "scaled pixel" units.
     */
    fun setTextSize(size : Float) = buttonTextView.let {
        it.textSize = size
    }

    /**
     * Set the [color] for the button text and border. The background is transparent.
     */
    fun setColor(color : Int) {
        buttonTextView.let {
            it.setTextColor(color)
        }

        buttonContainerView.let {
            val shape = GradientDrawable()
            shape.shape = GradientDrawable.RECTANGLE
            shape.setColor(Color.TRANSPARENT)
            shape.setStroke(5, color)
            shape.cornerRadius = 15f;

            it.background = shape
        }
    }
}