package com.flybits.concierge.smartrewards.viewproviders

import android.support.v7.widget.LinearLayoutManager
import android.support.v7.widget.PagerSnapHelper
import android.support.v7.widget.RecyclerView
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.bumptech.glide.request.RequestOptions
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.FlybitsViewProvider
import com.flybits.concierge.smartrewards.R
import com.flybits.concierge.smartrewards.fragments.OfferFragment
import com.flybits.concierge.smartrewards.model.Offer
import com.flybits.concierge.smartrewards.model.Offers
import com.flybits.concierge.smartrewards.utils.ViewHelper
import com.flybits.concierge.viewholders.FlybitsViewHolder

class OffersViewProvider : FlybitsViewProvider <Offers> {
    override fun getClassType(): Class<Offers> {
        return Offers::class.java
    }

    override fun getContentType(): String {
        return "ctn-flybits-offers-card"
    }

    override fun onCreateViewHolder(parent: ViewGroup): FlybitsViewHolder<Offers> {
        return OffersViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.smartrewards_item_template_offers, parent, false))
    }

    override fun onPushOpened(model: Offers, flybitsNavigator: FlybitsNavigator) {

    }

    companion object {
        private fun configureView(data: Offer, offerView: View, flybitsNavigator: FlybitsNavigator) {
            val bannerView : ImageView = offerView.findViewById(R.id.smartrewards_item_template_offer_banner)
            val headerView : TextView = offerView.findViewById(R.id.smartrewards_item_template_offer_header)
            val titleView : TextView = offerView.findViewById(R.id.smartrewards_item_template_offer_title)
            val subtitleView : TextView = offerView.findViewById(R.id.smartrewards_item_template_offer_subtitle)

            if (!TextUtils.isEmpty(data.banner)) { // banner is optional
                Glide.with(bannerView.context).load(data.banner).apply(RequestOptions().centerCrop()).into(bannerView)
            } else {
                bannerView.setImageResource(android.R.drawable.ic_menu_gallery)
            }

            headerView.text = data.header.value
            titleView.text = data.title.value
            subtitleView.text = data.subtitle.value

            offerView.setOnClickListener {
                flybitsNavigator.openFragment(OfferFragment.newInstance(data))
            }
        }
    }

    class OffersViewHolder(val view: View) : FlybitsViewHolder<Offers>(view) {
        private val recycler : RecyclerView = view.findViewById(R.id.smartrewards_item_template_offers_recyclerView)
        private val single : View = view.findViewById(R.id.smartrewards_item_template_offers_single)
        private val emptyView : View = view.findViewById(R.id.smartrewards_item_template_offers_emptyTxt)
        private val snapHelper = PagerSnapHelper()

        override fun bindData(data: Offers, flybitsNavigator: FlybitsNavigator) {
            recycler.visibility = View.GONE
            single.visibility = View.GONE
            emptyView.visibility = View.GONE

            when (data.offers.size) {
                0 -> {
                    emptyView.visibility = View.VISIBLE
                }
                1 -> {
                    single.visibility = View.VISIBLE
                    configureView(data.offers[0], view, flybitsNavigator)
                }
                else -> {
                    recycler.visibility = View.VISIBLE
                    recycler.layoutManager = LinearLayoutManager(recycler.context, LinearLayoutManager.HORIZONTAL, false)
                    recycler.adapter = OffersRecyclerAdapter(data.offers, flybitsNavigator)
                    recycler.onFlingListener = null // need to unset the fling listener. platform bug
                    snapHelper.attachToRecyclerView(recycler)
                }
            }
        }
    }

    class OffersRecyclerAdapter(private val offers : List<Offer>, private val flybitsNavigator: FlybitsNavigator) : RecyclerView.Adapter<OffersRecyclerAdapter.ViewHolder>() {

        class ViewHolder(val view: View) : RecyclerView.ViewHolder(view) {
            init {
                view.layoutParams.width = ViewHelper.cardPeekWidth(view.context)
            }
        }

        override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): OffersRecyclerAdapter.ViewHolder {
            return OffersRecyclerAdapter.ViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.smartrewards_item_template_offer, parent, false))
        }

        override fun getItemCount(): Int {
            return offers.size
        }

        override fun onBindViewHolder(holder: ViewHolder, position: Int) {
            configureView(offers[position], holder.view, flybitsNavigator)
        }
    }
}