package com.flybits.concierge.smartrewards.viewproviders

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import android.widget.Toast
import com.bumptech.glide.Glide
import com.bumptech.glide.request.RequestOptions
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.FlybitsViewProvider
import com.flybits.concierge.smartrewards.R
import com.flybits.concierge.smartrewards.model.Confirmation
import com.flybits.concierge.viewholders.FlybitsViewHolder

class ConfirmationViewProvider : FlybitsViewProvider<Confirmation> {
    override fun getClassType(): Class<Confirmation> {
        return Confirmation::class.java
    }

    override fun getContentType(): String {
        return "ctn-flybits-reward-confirmation-card"
    }

    override fun onCreateViewHolder(parent: ViewGroup): FlybitsViewHolder<Confirmation> {
        return ConfirmationViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.smartrewards_item_template_reward, parent, false))

    }

    override fun onPushOpened(model: Confirmation, flybitsNavigator: FlybitsNavigator) {

    }


    // View Holder for the Benefit Card
    class ConfirmationViewHolder(val view: View) : FlybitsViewHolder<Confirmation>(view) {

        private val headerView: TextView = view.findViewById(R.id.smartrewards_item_template_reward_header)
        private val titleView: TextView = view.findViewById(R.id.smartrewards_item_template_reward_title)
        private val descriptionView: TextView = view.findViewById(R.id.smartrewards_item_template_reward_description)
        private val iconView: ImageView = view.findViewById(R.id.smartrewards_item_template_reward_icon)
        private val ctaContainerView: View = view.findViewById(R.id.smartrewards_item_template_reward_cta_container)
        private val resultStatusView: TextView = view.findViewById(R.id.smartrewards_item_template_reward_result_status)
        private val resultButton: TextView = view.findViewById(R.id.smartrewards_item_template_reward_result_btn)

        private val backgroundView: ImageView = view.findViewById(R.id.smartrewards_item_template_reward_background_image)
        private val gradientView: View = view.findViewById(R.id.smartrewards_item_template_reward_gradient)

        override fun bindData(data: Confirmation, flybitsNavigator: FlybitsNavigator) {
            data.gradientDrawable?.let {
                gradientView.background = it
            }

            headerView.text = data.header.value
            titleView.text = data.title.value
            descriptionView.text = data.explanation.value
            resultStatusView.text = data.rewardStatus

            Glide.with(iconView.context).load(data.icon).into(iconView)

            ctaContainerView.visibility = View.GONE

            // Build Background
            gradientView.alpha = 1.0f
            backgroundView.visibility = View.GONE

            data.backgroundImage?.let {
                backgroundView.visibility = View.VISIBLE
                gradientView.alpha = 0.6f
                Glide.with(iconView.context).load(it).apply(RequestOptions().centerCrop()).into(backgroundView)
            }

            resultButton.visibility = View.INVISIBLE
            if (data.primaryButton.label != null) {
                resultButton.visibility = View.VISIBLE
                resultButton.text = data.primaryButton.label.value
                resultButton.setBackgroundColor(data.primaryButton.getColor())
                resultButton.setOnClickListener {
                    // TODO: Implement real functionality
                    Toast.makeText(resultButton.context, data.primaryButton.label.value, Toast.LENGTH_SHORT).show()
                }
            }

        }
    }
}