/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.smartrewards.model;

import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.smartrewards.model.ActionTypeButton;
import com.flybits.concierge.smartrewards.utils.ColorHelper;
import java.util.List;

public class Confirmation
extends BaseTemplate {
    public LocalizedValue header;
    public LocalizedValue title;
    public LocalizedValue explanation;
    public String icon;
    public ActionTypeButton primaryButton;
    public String backgroundImage;
    public String backgroundColor;
    public List<String> gradientRange;
    public String rewardStatus;
    private GradientDrawable gradientDrawable;
    public static final Parcelable.Creator<Confirmation> CREATOR = new Parcelable.Creator<Confirmation>(){

        public Confirmation createFromParcel(Parcel in) {
            return new Confirmation(in);
        }

        public Confirmation[] newArray(int size) {
            return new Confirmation[size];
        }
    };

    public Confirmation() {
    }

    public Confirmation(Parcel in) {
        super(in);
        this.header = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.title = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.explanation = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.icon = in.readString();
        this.primaryButton = (ActionTypeButton)in.readParcelable(ActionTypeButton.class.getClassLoader());
        this.backgroundImage = in.readString();
        this.backgroundColor = in.readString();
        this.gradientRange = in.createStringArrayList();
        this.rewardStatus = in.readString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.header, flags);
        dest.writeParcelable((Parcelable)this.title, flags);
        dest.writeParcelable((Parcelable)this.explanation, flags);
        dest.writeString(this.icon);
        dest.writeParcelable((Parcelable)this.primaryButton, flags);
        dest.writeString(this.backgroundImage);
        dest.writeString(this.backgroundColor);
        dest.writeStringList(this.gradientRange);
        dest.writeString(this.rewardStatus);
    }

    public int getBackgroundColor() {
        return !TextUtils.isEmpty((CharSequence)this.backgroundColor) ? Color.parseColor((String)this.backgroundColor) : ColorHelper.INSTANCE.defaultBackgroundColor();
    }

    public GradientDrawable getGradientDrawable() {
        if (this.gradientRange == null || this.gradientRange.isEmpty()) {
            return null;
        }
        if (this.gradientDrawable != null) {
            return this.gradientDrawable;
        }
        this.gradientDrawable = ColorHelper.INSTANCE.generateGradientDrawable(this.gradientRange);
        return this.gradientDrawable;
    }

    public int describeContents() {
        return 0;
    }
}

