package com.flybits.concierge.smartrewards

import android.content.Context
import com.flybits.commons.library.api.idps.IDP
import com.flybits.concierge.FlybitsConcierge
import com.flybits.concierge.enums.ShowMode
import com.flybits.concierge.smartrewards.viewproviders.BenefitsViewProvider
import com.flybits.concierge.smartrewards.viewproviders.ConfirmationViewProvider
import com.flybits.concierge.smartrewards.viewproviders.OffersViewProvider
import com.flybits.concierge.smartrewards.viewproviders.OptInViewProvider

class SmartRewardsConcierge  {
    private var flybitsConcierge: FlybitsConcierge? = null

    companion object {
        @Volatile private var INSTANCE: SmartRewardsConcierge? = null

        fun getInstance(context: Context) : SmartRewardsConcierge? {

            if (INSTANCE == null) synchronized(this) {
                INSTANCE = buildSmartRewardsConcierge(context)
            }

            // Assign new context to FlybitsConcierge
            FlybitsConcierge.with(context)

            return INSTANCE
        }

        private fun buildSmartRewardsConcierge(context: Context): SmartRewardsConcierge {

            val fbConcierge = FlybitsConcierge.with(context)

            // register custom content types here
            fbConcierge.registerFlybitsViewProvider(BenefitsViewProvider())
            fbConcierge.registerFlybitsViewProvider(OffersViewProvider())
            fbConcierge.registerFlybitsViewProvider(OptInViewProvider())
            fbConcierge.registerFlybitsViewProvider(ConfirmationViewProvider())


            val concierge = SmartRewardsConcierge()
            concierge.setFlybitsConcierge(fbConcierge)

            return concierge
        }
    }

    private fun setFlybitsConcierge(concierge: FlybitsConcierge) {
        flybitsConcierge = concierge
    }

    fun initialize(config: Int) {
        flybitsConcierge?.initialize(config)
    }

    fun isAuthenticated() : Boolean? = flybitsConcierge?.isAuthenticated

    fun authenticate(idp: IDP) {
        flybitsConcierge?.authenticate(idp)
    }

    fun show(showMode: ShowMode) {
        flybitsConcierge?.show(showMode)
    }
}