package com.flybits.concierge.smartrewards

import android.content.Context
import android.os.Handler
import com.flybits.commons.library.analytics.Analytics

class SmartRewardsAnalytics(private val context: Context) : Analytics(context) {
    companion object {
        const val analyticsScope = "smartRewardsAnalytics"
    }

    private enum class Action(val actionName: String) {
        ENGAGED("engaged")
    }

    fun trackEngagedContent(contentId: String, timestamp: Long = System.currentTimeMillis(), handler: Handler = Handler()) {
        track(Action.ENGAGED, contentId, timestamp, handler)
    }

    private fun track(action: Action, contentId: String, timestamp: Long, handler: Handler = Handler()) {
        super.track(Event(analyticsScope, action.actionName, contentId, timestamp))

        handler.postDelayed({
            // if the device is online, send the data right away
            if (com.pierfrancescosoffritti.androidyoutubeplayer.utils.Utils.isOnline(context)) {
                flush(null, true)
            }
        },1000)
    }
}