/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.http;

import android.content.Context;
import com.flybits.commons.library.FlyingConstants;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.api.FlyJWT;
import com.flybits.commons.library.api.FlybitsAPIConstants;
import com.flybits.commons.library.deserializations.DeserializeServerResult;
import com.flybits.commons.library.exceptions.FlybitsDisabledException;
import com.flybits.commons.library.exceptions.InvalidFlybitsResponseException;
import com.flybits.commons.library.http.GzipRequestInterceptor;
import com.flybits.commons.library.http.HttpHelper;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.LogType;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.models.internal.ServerResult;
import com.flybits.commons.library.utils.Utilities;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;

abstract class a {
    private final int a = 1;
    private int b;
    public static final String TAG_NETWORK = "Flybits_Network";
    private final int c = 503;
    private final int d = 401;
    private final String e = "X-Authorization";
    private final String f = "X-Flybits-Authenticated";
    private OkHttpClient g;
    private Request h;
    private Context i;
    private GzipRequestInterceptor j;

    @Deprecated
    public a(Context context) {
        this(context, false);
    }

    public a(Context context, boolean bl) {
        this.i = context;
        this.b = 0;
        this.g = HttpHelper.getClient(context);
        if (bl) {
            this.j = new GzipRequestInterceptor();
            this.enableGzip();
        }
    }

    protected void setRequest(Request request) {
        this.h = request;
    }

    protected Request.Builder setupRequest(Context context, String url) {
        String string;
        Request.Builder builder = new Request.Builder().url(url).header("User-Agent", Utilities.getUserAgentAsJSON()).header("Accept", "application/json").header("Content-Type", "application/json").header("flybits-sdk-version", Utilities.getSDKVersion()).header("physicalDeviceId", Utilities.getDeviceID(context));
        String string2 = FlybitsAPIConstants.getAPIKey(context);
        if (string2 != null) {
            builder.header("ApiKey", string2);
        }
        if (SharedElements.getEnabledLanguagesAsString(context).length() > 0) {
            builder.addHeader("Accept-Language", SharedElements.getEnabledLanguagesAsString(context));
        }
        if ((string = SharedElements.getSavedJWTToken(context)) != null && string.length() > 0) {
            builder.addHeader("X-Authorization", SharedElements.getSavedJWTToken(context));
        }
        return builder;
    }

    protected void enableGzip() {
        Logger.instance(FlyingConstants.IS_DEBUG)._LOG(TAG_NETWORK, "Interceptor Size: " + this.g.interceptors().size(), LogType.INFO);
        this.g.interceptors().add(this.j);
    }

    protected void disableGzip() {
        if (this.g.interceptors().size() > 0) {
            this.g.interceptors().clear();
        }
    }

    public ServerResult getResponse() throws IOException, FlybitsDisabledException {
        Object object;
        ServerResult serverResult = new ServerResult();
        long l = System.currentTimeMillis();
        Response response = this.g.newCall(this.h).execute();
        serverResult.status = response.code();
        if (response.message() != null) {
            serverResult.status_message = response.message();
        }
        Logger.instance(FlyingConstants.IS_DEBUG)._LOG(TAG_NETWORK, "Response - Time to Process Request: " + (System.currentTimeMillis() - l), LogType.DEBUG);
        Logger.instance(FlyingConstants.IS_DEBUG)._LOG(TAG_NETWORK, "Response Code: " + serverResult.status, LogType.DEBUG);
        serverResult.response = response.body().string();
        if (serverResult.status == 503) {
            Result result = new DeserializeServerResult().fromJson(serverResult.response);
            if (result.exception != null && result.exception.getMessage() != null) {
                throw new FlybitsDisabledException(result.exception.getMessage());
            }
            throw new FlybitsDisabledException("Flybits is currently not available");
        }
        try {
            Logger.instance(FlyingConstants.IS_DEBUG)._LOG(TAG_NETWORK, "Response - Result: " + serverResult.response.replace("\r\n", ""), LogType.DEBUG);
        }
        catch (Exception exception) {
            Logger.instance(FlyingConstants.IS_DEBUG)._LOG_EXCEPTION(exception);
        }
        if (serverResult.status == 401 && this.b < 1) {
            ++this.b;
            try {
                object = FlyJWT.refreshJWT(this.i);
                if (object.responseStatus == RequestStatus.SUCCESS) {
                    return this.a(this.i);
                }
            }
            catch (InvalidFlybitsResponseException invalidFlybitsResponseException) {
                Logger.instance(FlyingConstants.IS_DEBUG)._LOG_EXCEPTION(invalidFlybitsResponseException);
            }
        }
        object = response.headers();
        for (int i = 0; i < object.size(); ++i) {
            if (object.name(i).equalsIgnoreCase("X-Authorization")) {
                SharedElements.setJWTToken(this.i, object.value(i));
            }
            if (!object.name(i).equalsIgnoreCase("X-Flybits-Authenticated")) continue;
            SharedElements.setFlybitsXAuthentication(this.i, Boolean.valueOf(object.value(i)));
        }
        return serverResult;
    }

    abstract ServerResult a(Context var1) throws IOException, FlybitsDisabledException;
}

