/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.ServerException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.utils.TimeUtilities;
import java.text.ParseException;
import java.util.Calendar;
import org.json.JSONObject;

public class DeserializeServerResult
implements IDeserializer<Result> {
    @Override
    public String toJson(Result obj) {
        return null;
    }

    @Override
    public Result fromJson(String json) {
        Result result;
        block6: {
            result = new Result();
            try {
                JSONObject jSONObject = new JSONObject(json);
                if (jSONObject.isNull("exceptionType")) break block6;
                result.responseStatus = RequestStatus.FAILED;
                result.exception = !jSONObject.isNull("exceptionMessage") ? new ServerException(jSONObject.getString("exceptionMessage")) : new ServerException("There was a server issue detected");
                if (!jSONObject.isNull("exceptionType")) {
                    result.exception.exceptionType = jSONObject.getString("exceptionType");
                }
                if (jSONObject.isNull("dateTime")) break block6;
                String string = jSONObject.getString("dateTime");
                try {
                    Calendar calendar = TimeUtilities.toCalendarT(string);
                    if (calendar != null) {
                        result.exception.dateTime = calendar.getTimeInMillis();
                        break block6;
                    }
                    result.exception.dateTime = -1L;
                }
                catch (ParseException parseException) {
                    result.exception.dateTime = -1L;
                }
            }
            catch (Exception exception) {
                result.responseStatus = RequestStatus.FAILED;
                result.exception = new ServerException("Error Parsing Response");
            }
        }
        return result;
    }
}

