/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.FlyingConstants;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.ServerException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.DateOfBirth;
import com.flybits.commons.library.models.User;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.utils.TimeUtilities;
import java.text.ParseException;
import java.util.Calendar;
import org.json.JSONException;
import org.json.JSONObject;

public class DeserializeLogin
implements IDeserializer<Result<User>> {
    @Override
    public String toJson(Result<User> obj) {
        return null;
    }

    @Override
    public Result<User> fromJson(String json) {
        Result<User> result;
        block17: {
            result = new Result<User>();
            try {
                JSONObject jSONObject = new JSONObject(json);
                if (!jSONObject.isNull("exceptionType")) {
                    result.responseStatus = RequestStatus.FAILED;
                    if (!jSONObject.isNull("exceptionMessage")) {
                        result.exception = new ServerException(jSONObject.getString("exceptionMessage"));
                    }
                    if (result.exception != null && !jSONObject.isNull("exceptionType")) {
                        result.exception.exceptionType = jSONObject.getString("exceptionType");
                    }
                    if (result.exception == null || jSONObject.isNull("dateTime")) break block17;
                    String string = jSONObject.getString("dateTime");
                    try {
                        Calendar calendar = TimeUtilities.toCalendarT(string);
                        if (calendar != null) {
                            result.exception.dateTime = calendar.getTimeInMillis();
                            break block17;
                        }
                        result.exception.dateTime = -1L;
                    }
                    catch (ParseException parseException) {
                        result.exception.dateTime = -1L;
                    }
                    break block17;
                }
                if (!jSONObject.isNull("id")) {
                    result.response = new User();
                    result.responseStatus = RequestStatus.SUCCESS;
                    ((User)result.response).id = jSONObject.getString("id");
                    if (result.response != null && !jSONObject.isNull("firstName")) {
                        ((User)result.response).firstName = jSONObject.getString("firstName");
                    }
                    if (result.response != null && !jSONObject.isNull("lastName")) {
                        ((User)result.response).lastName = jSONObject.getString("lastName");
                    }
                    if (result.response != null && !jSONObject.isNull("icon")) {
                        ((User)result.response).setIcon(jSONObject.getString("icon"));
                    }
                    if (result.response != null && !jSONObject.isNull("email")) {
                        ((User)result.response).email = jSONObject.getString("email");
                    }
                    if (result.response != null && !jSONObject.isNull("credentialsJwt")) {
                        ((User)result.response).jwtToken = jSONObject.getString("credentialsJwt");
                    }
                    ((User)result.response).gender = result.response != null && !jSONObject.isNull("gender") ? User.Gender.fromKey(jSONObject.getString("gender")) : User.Gender.UNKNOWN;
                    if (result.response == null || jSONObject.isNull("dateOfBirth")) break block17;
                    try {
                        Calendar calendar = TimeUtilities.toCalendarT(jSONObject.getString("dateOfBirth"));
                        if (calendar != null) {
                            ((User)result.response).dateOfBirth = new DateOfBirth();
                            ((User)result.response).dateOfBirth.year = calendar.get(1);
                            ((User)result.response).dateOfBirth.month = calendar.get(2) + 1;
                            ((User)result.response).dateOfBirth.day = calendar.get(5);
                        }
                        break block17;
                    }
                    catch (ParseException parseException) {
                        Logger.instance(FlyingConstants.IS_DEBUG)._LOG_EXCEPTION(parseException);
                    }
                    break block17;
                }
                result.responseStatus = RequestStatus.FAILED;
                result.exception = new ServerException("There was a server issue detected");
            }
            catch (JSONException jSONException) {
                result.responseStatus = RequestStatus.FAILED;
                result.exception = new ServerException("Error Parsing Response");
            }
        }
        return result;
    }
}

