/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.flybits.commons.library.FlyingConstants;
import com.flybits.commons.library.exceptions.APIKeyNotSetException;
import com.flybits.commons.library.logging.Logger;

public class FlybitsAPIConstants {
    protected static final String API_V2 = "/v2";
    protected static final String API_USER = "/Users";
    protected static final String API_JWT = "/jwt";
    protected static final String API_IMAGE = "/Images";
    protected static final String API_DEVICES = "/Devices";
    public static final String API_LOGIN = "/Users/Login";
    public static final String API_LOGIN_SIGNED = "/Users/SignedLogin";
    protected static final String API_LOGOUT = "/Users/Logout";
    protected static final String API_REGISTER = "/Users/Register";
    protected static final String API_REMEMBERME = "/Users/rememberMe";
    protected static final String API_FORGOT_PASSWORD = "/Users/SendResetPasswordEmail";
    protected static final String API_CHANGE_PASSWORD = "/Users/ChangePassword";
    protected static final String API_CHANGE_EMAIL = "/Users/ChangeEmail";
    protected static final String API_IMAGE_UPLOAD = "/Images/Upload";
    protected static final String API_IMAGE_CROP = "/Images/Crop";
    protected static final String API_ME = "/me";
    public static final String USER_ACCESS_DENIED = "AccessDenied";

    public static String getURL() {
        return "https://api.flybits.com/v2";
    }

    public static String getURI() {
        return "https://api.flybits.com";
    }

    public static String getGatewayURL() throws APIKeyNotSetException {
        return "https://gateway.flybits.com";
    }

    public static String getMQTTURL() throws APIKeyNotSetException {
        return "ssl://mqtt.gateway.flybits.com:443";
    }

    public static String constructURL(String endpoint) {
        return FlybitsAPIConstants.getURL() + endpoint;
    }

    public static String getAPIKey(Context context) throws APIKeyNotSetException {
        return FlybitsAPIConstants.getMyAPIKey(context);
    }

    public static String constructGatewayURL(String endpoint) {
        return FlybitsAPIConstants.getGatewayURL() + endpoint;
    }

    public static String getMyAPIKey(Context mContext) throws APIKeyNotSetException {
        try {
            ApplicationInfo applicationInfo = mContext.getPackageManager().getApplicationInfo(mContext.getPackageName(), 128);
            Bundle bundle = applicationInfo.metaData;
            if (bundle.containsKey("com.flybits.apikey")) {
                return bundle.getString("com.flybits.apikey");
            }
        }
        catch (PackageManager.NameNotFoundException | NullPointerException throwable) {
            Logger.instance(FlyingConstants.IS_DEBUG)._LOG_EXCEPTION((Exception)throwable);
        }
        throw new APIKeyNotSetException("Your Api Key is not set. Please set it through the FlybitsOptions object and make sure you initialize the Flybits singleton with the FlybitsOptions object.");
    }
}

