package com.flybits.commons.library.models;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * A class that represents the information about the date of birth for a particular user. The date
 * of birth is designed using the day, month, and year corresponding to the birth of the user. This
 * object should be directly accessed from {@link User} object.
 *
 * @since 1.0.0
 */
public class DateOfBirth implements Parcelable {

    /**
     * The day number of the month the user was born on. Values range from 1-31.
     */
    public int day = -1;

    /**
     * The month number of the year that the user was born on. Values range from 1-12.
     */
    public int month = -1;

    /**
     * The year number that the user was born on.
     */
    public int year = -1;

    /**
     * Default constructor that creates an empty {@code DateOfBirth} object.
     */
    public DateOfBirth(){}

    /**
     * Constructor used for un-flattening a {@code DateOfBirth} parcel.
     *
     * @param in the parcel that contains the un-flattened {@code DateOfBirth} parcel.
     */
    public DateOfBirth(Parcel in){
        year    = in.readInt();
        month   = in.readInt();
        day     = in.readInt();
    }

    /**
     * Describe the kinds of special objects contained in this Parcelable's marshalled representation.
     *
     * @return a bitmask indicating the set of special object types marshalled by the Parcelable.
     */
    public int describeContents() {
        return 0;
    }

    /**
     * Flatten this {@code DateOfBirth} into a Parcel.
     *
     * @param out The Parcel in which the {@code DateOfBirth} object should be written.
     * @param flags Additional flags about how the DateOfBirth object should be written.
     * May be 0 or {@link #PARCELABLE_WRITE_RETURN_VALUE}.
     */
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(year);
        out.writeInt(month);
        out.writeInt(day);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DateOfBirth that = (DateOfBirth) o;

        if (day != that.day) return false;
        if (month != that.month) return false;
        return year == that.year;

    }

    @Override
    public String toString() {
        return year + "-" + month + "-" + day;
    }

    /**
     * Parcelable.Creator that instantiates {@code DateOfBirth} objects
     */
    public static final Creator<DateOfBirth> CREATOR = new Creator<DateOfBirth>(){
        public DateOfBirth createFromParcel(Parcel in){
            return new DateOfBirth(in);
        }

        public DateOfBirth[] newArray(int size){
            return new DateOfBirth[size];
        }
    };
}
