package com.flybits.commons.library.interfaces;

import com.flybits.commons.library.models.User;

/**
 * This callback is initiated by the SDK when a web request, to determine whether or not the
 * application is logged in, is made.
 *
 * @since 1.0.0
 */
public interface IRequestLoggedIn {

    /**
     * Indicates that the application is logged in to the Flybits core.
     *
     * @param user The currently logged in user.
     */
    void onLoggedIn(User user);

    /**
     * Indicates that the application is not logged in to the Flybits core.
     */
    void onNotLoggedIn();
}
