package com.flybits.commons.library.interfaces;

/**
 * This callback is initiated by the SDK when a web request does not expect any object in the
 * response body. For example, whenever a user sets a zone as a favourite all that the request will
 * indicate is whether or not the request was successful or not. If not then the reason for failure
 * will be sent to the application.
 *
 * @since 1.0.0
 */
public abstract class IRequestGeneralCallback extends IGenericAbstractCallback {

    /**
     * Indicates that the SDK request to the Flybits Core was successfully performed.
     */
    public abstract void onSuccess();
}
