package com.flybits.commons.library.http;

/**
 * Network Response Status Codes.
 *
 * @author Petar Kramaric
 * @since 2.0
 */
public enum RequestStatus {

    /**
     * The network request was successful.
     */
    SUCCESS,

    /**
     * The network request failed with the server providing a reason for failure.
     */
    FAILED,

    /**
     * The network request failed as the resource was not found
     */
    NOT_FOUND,

    /**
     * The network request failed with an unknown server error.
     */
    @Deprecated
    FAILED_WITHOUT_MESSAGE
}
