package com.flybits.commons.library.http;

import android.content.Context;

import java.net.CookieManager;
import java.net.CookiePolicy;

public class HttpHelper {

    private static FlybitsHttpClient client;

    private HttpHelper() { }

    public static void setClient(Context context, FlybitsHttpClient newClient){
        synchronized (HttpHelper.class){
            client = newClient;
            if (client.getCookieHandler() == null){
                PersistentCookieStore cookieStore   = new PersistentCookieStore(context);
                CookieManager manager               = new CookieManager(cookieStore, CookiePolicy.ACCEPT_ALL);
                client.setCookieHandler(manager);
            }
        }
    }

    public static FlybitsHttpClient getClient(Context context) {

        if (client == null) {
            synchronized (HttpHelper.class){
                client = new FlybitsHttpClient();
                PersistentCookieStore cookieStore   = new PersistentCookieStore(context);
                CookieManager manager               = new CookieManager(cookieStore, CookiePolicy.ACCEPT_ALL);
                client.setCookieHandler(manager);
            }
        }
        return client;
    }

    /*
    public HttpHelper(Context context){
        client = new OkHttpClient();
        PersistentCookieStore cookieStore   = new PersistentCookieStore(context);
        CookieManager manager               = new CookieManager(cookieStore, CookiePolicy.ACCEPT_ALL);
        client.setCookieHandler(manager);
    }
    */
}
