package com.flybits.commons.library.exceptions;

/**
 *  The {@code PermissionNotSetException} is thrown whenever the application has not added a
 *  permission to the {@code AndroidManifest.xml} file that is needed to continue.
 *
 *  @since 1.0.0
 */
public class PermissionNotSetException extends RuntimeException {

    /**
     * Constructs a new {@code PermissionNotSetException} that includes the current stack trace.
     */
    public PermissionNotSetException() {}

    /**
     * Constructs a new {@code PermissionNotSetException} with the current stack trace and the specified
     * detail message.
     *
     * @param message the detail message for this exception.
     */
    public PermissionNotSetException(String message) {
        super(message);
    }

    /**
     * Constructs a new {@code PermissionNotSetException} with the current stack trace and the specified
     * cause.
     *
     * @param throwable the cause of this exception.
     */
    public PermissionNotSetException(Throwable throwable) {
        super(throwable);
    }

    /**
     * Constructs a new {@code PermissionNotSetException} with the current stack trace,
     * the specified detail message and the specified cause.
     *
     * @param detailMessage the detail message for this exception.
     * @param throwable the cause of this exception.
     */
    public PermissionNotSetException(String detailMessage, Throwable throwable) {
        super(detailMessage, throwable);
    }
}