package com.flybits.commons.library.exceptions;

/**
 *  The {@code APIKeyNotSetException} is thrown when an application attempts to access any of the
 *  SDK methods without initializing the API keys that set using through the AndroidManifest.xml
 *  file. The API Key that need to be defined through the meta-data tags are as follows:
 *  <ul>
 *     <li>com.flybits.apikey</li>
 *  </ul>
 *
 * @since 1.0.0
 */
public class APIKeyNotSetException extends RuntimeException {

    /**
     * Constructs a new {@code APIKeyNotSetException} that includes the current stack trace.
     */
    public APIKeyNotSetException() {}

    /**
     * Constructs a new {@code APIKeyNotSetException} with the current stack trace and the specified
     * detail message.
     *
     * @param message the detail message for this exception.
     */
    public APIKeyNotSetException(String message) {
        super(message);
    }

    /**
     * Constructs a new {@code APIKeyNotSetException} with the current stack trace and the specified
     * cause.
     *
     * @param throwable the cause of this exception.
     */
    public APIKeyNotSetException(Throwable throwable) {
        super(throwable);
    }

    /**
     * Constructs a new {@code APIKeyNotSetException} with the current stack trace,
     * the specified detail message and the specified cause.
     *
     * @param detailMessage the detail message for this exception.
     * @param throwable the cause of this exception.
     */
    public APIKeyNotSetException(String detailMessage, Throwable throwable) {
        super(detailMessage, throwable);
    }
}