package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.exceptions.ServerException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.utils.TimeUtilities;

import org.json.JSONObject;

import java.text.ParseException;
import java.util.Calendar;

public class DeserializeServerResult implements IDeserializer<Result>{

    @Override
    public String toJson(Result obj) {
        return null;
    }

    @Override
    public Result fromJson(String json) {

        Result exception = new Result<>();

        try {
            JSONObject jObj = new JSONObject(json);

            if (!jObj.isNull("exceptionType")){
                exception.responseStatus    = RequestStatus.FAILED;

                if (!jObj.isNull("exceptionMessage")){
                    exception.exception         = new ServerException(jObj.getString("exceptionMessage"));
                }else{
                    exception.exception         = new ServerException("There was a server issue detected");
                }

                if (!jObj.isNull("exceptionType")){
                    exception.exception.exceptionType = jObj.getString("exceptionType");
                }

                if (!jObj.isNull("dateTime")) {
                    String date = jObj.getString("dateTime");
                    try {
                        Calendar calendar       = TimeUtilities.toCalendarT(date);
                        if (calendar != null) {
                            exception.exception.dateTime = calendar.getTimeInMillis();
                        }else{
                            exception.exception.dateTime = -1;
                        }
                    }catch(ParseException exceptionArgs){
                        exception.exception.dateTime = -1;
                    }
                }
            }

        }catch (Exception e){
            exception.responseStatus    = RequestStatus.FAILED;
            exception.exception         = new ServerException("Error Parsing Response");
        }
        return exception;
    }
}
