package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.FlyingConstants;
import com.flybits.commons.library.exceptions.ServerException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.DateOfBirth;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.models.User;
import com.flybits.commons.library.utils.TimeUtilities;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.util.Calendar;

public class DeserializeLogin implements IDeserializer<Result<User>>{

    @Override
    public String toJson(Result<User> obj) {
        return null;
    }

    @Override
    public Result<User> fromJson(String json) {

        Result<User> user = new Result<>();

        try {
            JSONObject jObj = new JSONObject(json);

            if (!jObj.isNull("exceptionType")){
                user.responseStatus    = RequestStatus.FAILED;

                if (!jObj.isNull("exceptionMessage")){
                    user.exception         = new ServerException(jObj.getString("exceptionMessage"));
                }

                if (user.exception != null && !jObj.isNull("exceptionType")){
                    user.exception.exceptionType = jObj.getString("exceptionType");
                }

                if (user.exception != null && !jObj.isNull("dateTime")) {
                    String date = jObj.getString("dateTime");
                    try {
                        Calendar calendar       = TimeUtilities.toCalendarT(date);
                        if (calendar != null) {
                            user.exception.dateTime = calendar.getTimeInMillis();
                        }else{
                            user.exception.dateTime = -1;
                        }
                    }catch(ParseException exceptionArgs){
                        user.exception.dateTime = -1;
                    }
                }
            }else{
                if (!jObj.isNull("id")){
                    user.response               = new User();
                    user.responseStatus         = RequestStatus.SUCCESS;
                    user.response.id            = jObj.getString("id");

                    if (user.response != null && !jObj.isNull("firstName")) {
                        user.response.firstName = jObj.getString("firstName");
                    }
                    if (user.response != null && !jObj.isNull("lastName")) {
                        user.response.lastName  = jObj.getString("lastName");
                    }
                    if (user.response != null && !jObj.isNull("icon")) {
                        user.response.setIcon(jObj.getString("icon"));
                    }
                    if (user.response != null && !jObj.isNull("email")) {
                        user.response.email = jObj.getString("email");
                    }
                    if (user.response != null && !jObj.isNull("credentialsJwt")) {
                        user.response.jwtToken = jObj.getString("credentialsJwt");
                    }
                    if (user.response != null && !jObj.isNull("gender")) {
                        user.response.gender = User.Gender.fromKey(jObj.getString("gender"));
                    }else{
                        user.response.gender    = User.Gender.UNKNOWN;
                    }
                    if (user.response != null && !jObj.isNull("dateOfBirth")) {
                        try {
                        Calendar calendar       = TimeUtilities.toCalendarT(jObj.getString("dateOfBirth"));
                        if (calendar != null) {
                            user.response.dateOfBirth          = new DateOfBirth();
                            user.response.dateOfBirth.year     = calendar.get(Calendar.YEAR);
                            user.response.dateOfBirth.month    = calendar.get(Calendar.MONTH) + 1;
                            user.response.dateOfBirth.day      = calendar.get(Calendar.DAY_OF_MONTH);
                        }
                        }catch(ParseException exception){
                            Logger.instance(FlyingConstants.IS_DEBUG)._LOG_EXCEPTION(exception);
                        }
                    }
                }else {
                    user.responseStatus     = RequestStatus.FAILED;
                    user.exception          = new ServerException("There was a server issue detected");
                }
            }
        }catch (JSONException e){
            user.responseStatus    = RequestStatus.FAILED;
            user.exception         = new ServerException("Error Parsing Response");
        }
        return user;
    }
}
